/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BackgroundColorBehavior
extends BootstrapBaseBehavior {
    private IModel<Color> colorModel;

    public BackgroundColorBehavior(Color color) {
        this((IModel<Color>)Model.of((Serializable)((Object)color)));
    }

    public BackgroundColorBehavior(IModel<Color> colorModel) {
        this.colorModel = colorModel;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, (ICssClassNameProvider)this.colorModel.getObject());
    }

    public BackgroundColorBehavior color(Color color) {
        this.colorModel.setObject((Object)color);
        return this;
    }

    public BackgroundColorBehavior color(IModel<Color> colorModel) {
        this.colorModel = colorModel;
        return this;
    }

    public Color getColor() {
        return (Color)this.colorModel.getObject();
    }

    public IModel<Color> getColorModel() {
        return this.colorModel;
    }

    public static BackgroundColorBehavior primary() {
        return new BackgroundColorBehavior(Color.Primary);
    }

    public static BackgroundColorBehavior primarySubtle() {
        return new BackgroundColorBehavior(Color.Primary_subtle);
    }

    public static BackgroundColorBehavior secondary() {
        return new BackgroundColorBehavior(Color.Secondary);
    }

    public static BackgroundColorBehavior secondarySubtle() {
        return new BackgroundColorBehavior(Color.Secondary_subtle);
    }

    public static BackgroundColorBehavior success() {
        return new BackgroundColorBehavior(Color.Success);
    }

    public static BackgroundColorBehavior successSubtle() {
        return new BackgroundColorBehavior(Color.Success_subtle);
    }

    public static BackgroundColorBehavior danger() {
        return new BackgroundColorBehavior(Color.Danger);
    }

    public static BackgroundColorBehavior dangerSubtle() {
        return new BackgroundColorBehavior(Color.Danger_subtle);
    }

    public static BackgroundColorBehavior warning() {
        return new BackgroundColorBehavior(Color.Warning);
    }

    public static BackgroundColorBehavior warningSubtle() {
        return new BackgroundColorBehavior(Color.Warning_subtle);
    }

    public static BackgroundColorBehavior info() {
        return new BackgroundColorBehavior(Color.Info);
    }

    public static BackgroundColorBehavior infoSubtle() {
        return new BackgroundColorBehavior(Color.Info_subtle);
    }

    public static BackgroundColorBehavior light() {
        return new BackgroundColorBehavior(Color.Light);
    }

    public static BackgroundColorBehavior lightSubtle() {
        return new BackgroundColorBehavior(Color.Light_subtle);
    }

    public static BackgroundColorBehavior dark() {
        return new BackgroundColorBehavior(Color.Dark);
    }

    public static BackgroundColorBehavior darkSubtle() {
        return new BackgroundColorBehavior(Color.Dark_subtle);
    }

    public static BackgroundColorBehavior bodySecondary() {
        return new BackgroundColorBehavior(Color.Body_secondary);
    }

    public static BackgroundColorBehavior bodyTertiary() {
        return new BackgroundColorBehavior(Color.Body_tertiary);
    }

    public static BackgroundColorBehavior body() {
        return new BackgroundColorBehavior(Color.Body);
    }

    public static BackgroundColorBehavior black() {
        return new BackgroundColorBehavior(Color.Black);
    }

    public static BackgroundColorBehavior white() {
        return new BackgroundColorBehavior(Color.White);
    }

    public static BackgroundColorBehavior transparent() {
        return new BackgroundColorBehavior(Color.Transparent);
    }

    public static enum Color implements ICssClassNameProvider
    {
        Primary("primary"),
        Primary_subtle("primary-subtle"),
        Secondary("secondary"),
        Secondary_subtle("secondary-subtle"),
        Success("success"),
        Success_subtle("success-subtle"),
        Danger("danger"),
        Danger_subtle("danger-subtle"),
        Warning("warning"),
        Warning_subtle("warning-subtle"),
        Info("info"),
        Info_subtle("info-subtle"),
        Light("light"),
        Light_subtle("light-subtle"),
        Dark("dark"),
        Dark_subtle("dark-subtle"),
        Body_secondary("body-secondary"),
        Body_tertiary("body-tertiary"),
        Body("body"),
        Black("black"),
        White("white"),
        Transparent("transparent");

        private final String cssClassName;

        private Color(String value) {
            this.cssClassName = "bg-" + value;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }
}

