/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.MathType;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedBucket
extends AbstractBucket
implements LocalBucket,
ComparableByContent<SynchronizedBucket> {
    private BucketConfiguration configuration;
    private final TimeMeter timeMeter;
    private BucketState state;
    private final Lock lock;
    public static final SerializationHandle<SynchronizedBucket> SERIALIZATION_HANDLE = new SerializationHandle<SynchronizedBucket>(){

        @Override
        public <S> SynchronizedBucket deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input);
            BucketState bucketState = BucketState.deserialize(adapter, input);
            bucketState.setConfiguration(bucketConfiguration);
            return new SynchronizedBucket(BucketListener.NOPE, TimeMeter.SYSTEM_MILLISECONDS, new ReentrantLock(), bucketState);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, SynchronizedBucket bucket, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, bucket.state.getConfiguration(), backwardCompatibilityVersion, scope);
            BucketState.serialize(adapter, output, bucket.state, backwardCompatibilityVersion, scope);
        }

        @Override
        public int getTypeId() {
            return 61;
        }

        @Override
        public Class<SynchronizedBucket> getSerializedType() {
            return SynchronizedBucket.class;
        }

        @Override
        public SynchronizedBucket fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            Map stateSnapshot = (Map)snapshot.get("state");
            BucketState state = BucketState.fromJsonCompatibleSnapshot(stateSnapshot);
            return new SynchronizedBucket(BucketListener.NOPE, TimeMeter.SYSTEM_MILLISECONDS, new ReentrantLock(), state);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(SynchronizedBucket bucket, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("state", BucketState.toJsonCompatibleSnapshot(bucket.state, backwardCompatibilityVersion, scope));
            return result;
        }

        @Override
        public String getTypeName() {
            return "SynchronizedBucket";
        }
    };

    public SynchronizedBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter) {
        this(configuration, mathType, timeMeter, new ReentrantLock());
    }

    SynchronizedBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter, Lock lock) {
        this(BucketListener.NOPE, timeMeter, lock, BucketState.createInitialState(configuration, mathType, timeMeter.currentTimeNanos()));
    }

    private SynchronizedBucket(BucketListener listener, TimeMeter timeMeter, Lock lock, BucketState initialState) {
        super(listener);
        this.configuration = initialState.getConfiguration();
        this.timeMeter = timeMeter;
        this.state = initialState;
        this.lock = lock;
    }

    public void setConfiguration(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Bucket toListenable(BucketListener listener) {
        return new SynchronizedBucket(listener, this.timeMeter, this.lock, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume <= 0L) {
                long l = 0L;
                return l;
            }
            this.state.consume(toConsume);
            long l = toConsume;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                boolean bl = false;
                return bl;
            }
            this.state.consume(tokensToConsume);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
                long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
                return consumptionProbe;
            }
            this.state.consume(tokensToConsume);
            long remainingTokens = availableToConsume - tokensToConsume;
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
            ConsumptionProbe consumptionProbe = ConsumptionProbe.consumed(remainingTokens, nanosToWaitForReset);
            return consumptionProbe;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToEstimate > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
                EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
                return estimationProbe;
            }
            EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
            return estimationProbe;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
                long l = Long.MAX_VALUE;
                return l;
            }
            this.state.consume(tokensToConsume);
            long l = nanosToCloseDeficit;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                long l = nanosToCloseDeficit;
                return l;
            }
            this.state.consume(tokensToConsume);
            long l = nanosToCloseDeficit;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume <= 0L) {
                VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, 0L, this.state.copy());
                return verboseResult;
            }
            this.state.consume(toConsume);
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, toConsume, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                VerboseResult<Boolean> verboseResult = new VerboseResult<Boolean>(currentTimeNanos, false, this.state.copy());
                return verboseResult;
            }
            this.state.consume(tokensToConsume);
            VerboseResult<Boolean> verboseResult = new VerboseResult<Boolean>(currentTimeNanos, true, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
                long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
                ConsumptionProbe probe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
                VerboseResult<ConsumptionProbe> verboseResult = new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.state.copy());
                return verboseResult;
            }
            this.state.consume(tokensToConsume);
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(currentTimeNanos);
            ConsumptionProbe probe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume, nanosToWaitForReset);
            VerboseResult<ConsumptionProbe> verboseResult = new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens();
            if (tokensToEstimate > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
                EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
                VerboseResult<EstimationProbe> verboseResult = new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.state.copy());
                return verboseResult;
            }
            EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
            VerboseResult<EstimationProbe> verboseResult = new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long availableTokens = this.state.getAvailableTokens();
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, availableTokens, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.addTokens(tokensToAdd);
            VerboseResult<Nothing> verboseResult = new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> forceAddTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.forceAddTokens(tokensToAdd);
            VerboseResult<Nothing> verboseResult = new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> resetVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.reset();
            VerboseResult<Nothing> verboseResult = new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            this.configuration = newConfiguration;
            VerboseResult<Object> verboseResult = new VerboseResult<Object>(currentTimeNanos, null, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.state.copy());
                return verboseResult;
            }
            this.state.consume(tokensToConsume);
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.addTokens(tokensToAdd);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceAddTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.forceAddTokens(tokensToAdd);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reset() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            long l = this.state.getAvailableTokens();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(currentTimeNanos);
            this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            this.configuration = newConfiguration;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    @Override
    public SynchronizationStrategy getSynchronizationStrategy() {
        return SynchronizationStrategy.SYNCHRONIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return "SynchronizedBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + "}";
        }
    }

    @Override
    public boolean equalsByContent(SynchronizedBucket other) {
        return ComparableByContent.equals(this.state, other.state) && ComparableByContent.equals(this.state.getConfiguration(), other.getConfiguration()) && this.timeMeter == other.timeMeter;
    }
}

