/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelContext;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\u0007\u000f\u0001MA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t?\u0001\u0011\t\u0011)A\u0005A!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!Y\u0003A!A!\u0002\u0013a\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B\u001c\u0001\t\u0013A\u0004\"\u0002#\u0001\t\u0003)\u0005b\u0002:\u0001#\u0003%\ta\u001d\u0005\u0006}\u0002!\te \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ti\u0002\u0001C!\u0003?\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007N\u0003\u0002\u0010!\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u001d%\u0011qC\u0004\u0002%\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u000611m\u001c8gS\u001e\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\t\u0002\rM,'O^3s\u0013\tq2DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001G2p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011Q#I\u0005\u0003E9\u0011\u0001dQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Y\u0019wN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\bCA\u000b&\u0013\t1cB\u0001\fD_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u0003+%J!A\u000b\b\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\"!F\u0017\n\u00059r!!E*uCR,7\t[1oO\u0016dunZ4fe\u00061A(\u001b8jiz\"b!\r\u001a4iU2\u0004CA\u000b\u0001\u0011\u0015Ab\u00011\u0001\u001a\u0011\u0015yb\u00011\u0001!\u0011\u0015\u0019c\u00011\u0001%\u0011\u00159c\u00011\u0001)\u0011\u0015Yc\u00011\u0001-\u0003%\u0019XM\u001c3Fm\u0016tG\u000f\u0006\u0002:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5u\u0011\u0015\u0001u\u00011\u0001B\u0003\u0015)g/\u001a8u!\t)\")\u0003\u0002D\u001d\ty1i\u001c8ue>dG.\u001a:Fm\u0016tG/A\u0006tK:$'+Z9vKN$H\u0003B\u001dG\u0017*DQa\u0012\u0005A\u0002!\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003u%K!AS\u001e\u0003\u0007%sG\u000fC\u0003M\u0011\u0001\u0007Q*A\u0004sKF,Xm\u001d;1\u00059\u000b\u0007cA(]?:\u0011\u0001KW\u0007\u0002#*\u0011!kU\u0001\te\u0016\fX/Z:ug*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005E1&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!aW)\u0002-\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2\u0014V-];fgRL!!\u00180\u0003\u000f\t+\u0018\u000e\u001c3fe*\u00111,\u0015\t\u0003A\u0006d\u0001\u0001B\u0005c\u0017\u0006\u0005\t\u0011!B\u0001G\n\u0019q\fJ\u001a\u0012\u0005\u0011<\u0007C\u0001\u001ef\u0013\t17HA\u0004O_RD\u0017N\\4\u0011\u0005AC\u0017BA5R\u0005Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\bbB6\t!\u0003\u0005\r\u0001\\\u0001\tG\u0006dGNY1dWB!!(\\8:\u0013\tq7HA\u0005Gk:\u001cG/[8ocA\u0011\u0001\u000b]\u0005\u0003cF\u0013\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002+M,g\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\tAO\u000b\u0002mk.\na\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003wn\n!\"\u00198o_R\fG/[8o\u0013\ti\bPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\u0004[1oI2,G*Z1eKJ\fe\u000eZ%teJ+7\u000f]8og\u0016$R!OA\u0001\u0003\u0017Aq!a\u0001\u000b\u0001\u0004\t)!\u0001\u0005sKN\u0004xN\\:f!\r\u0001\u0016qA\u0005\u0004\u0003\u0013\t&\u0001\u0006'fC\u0012,'/\u00118e\u0013N\u0014(+Z:q_:\u001cX\r\u0003\u0004\u0002\u000e)\u0001\r\u0001S\u0001\u0007EJ|7.\u001a:\u00029!\fg\u000e\u001a7f+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR)\u0011(a\u0005\u0002\u001c!9\u00111A\u0006A\u0002\u0005U\u0001c\u0001)\u0002\u0018%\u0019\u0011\u0011D)\u0003-U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016Da!!\u0004\f\u0001\u0004A\u0015!\u00075b]\u0012dWm\u0015;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016$r!OA\u0011\u0003W\ti\u0003C\u0004\u0002$1\u0001\r!!\n\u0002'M$x\u000e\u001d*fa2L7-\u0019*fgB|gn]3\u0011\u0007A\u000b9#C\u0002\u0002*E\u00131c\u0015;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016DQa\u0012\u0007A\u0002!Cq!a\f\r\u0001\u0004\t\t$\u0001\u0011qCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:t\r>\u0014H)\u001a7fi&tw\rV8qS\u000e\u001c\b\u0003CA\u001a\u0003\u0003\n9%a\u0014\u000f\t\u0005U\u0012Q\b\t\u0004\u0003oYTBAA\u001d\u0015\r\tYDE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}2(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)EA\u0002NCBT1!a\u0010<!\u0011\tI%a\u0013\u000e\u0003MK1!!\u0014T\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+\u001a\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005e\u00131\u000b\u0002\u0007\u000bJ\u0014xN]:")
public class ControllerBrokerRequestBatch
extends AbstractControllerBrokerRequestBatch {
    private final ControllerChannelManager controllerChannelManager;
    private final ControllerEventManager controllerEventManager;

    private void sendEvent(ControllerEvent event) {
        this.controllerEventManager.put(event);
    }

    @Override
    public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        this.controllerChannelManager.sendRequest(brokerId, request, callback);
    }

    @Override
    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    @Override
    public void handleLeaderAndIsrResponse(LeaderAndIsrResponse response, int broker) {
        this.sendEvent(new LeaderAndIsrResponseReceived(response, broker));
    }

    @Override
    public void handleUpdateMetadataResponse(UpdateMetadataResponse response, int broker) {
        this.sendEvent(new UpdateMetadataResponseReceived(response, broker));
    }

    @Override
    public void handleStopReplicaResponse(StopReplicaResponse stopReplicaResponse, int brokerId, scala.collection.immutable.Map<TopicPartition, Errors> partitionErrorsForDeletingTopics) {
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.sendEvent(new TopicDeletionStopReplicaResponseReceived(brokerId, stopReplicaResponse.error(), (Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics));
            return;
        }
    }

    public ControllerBrokerRequestBatch(KafkaConfig config, ControllerChannelManager controllerChannelManager, ControllerEventManager controllerEventManager, ControllerContext controllerContext, StateChangeLogger stateChangeLogger) {
        this.controllerChannelManager = controllerChannelManager;
        this.controllerEventManager = controllerEventManager;
        super(config, (Function0<ControllerChannelContext>)new Serializable(controllerContext){
            private static final long serialVersionUID = 0L;
            private final ControllerContext controllerContext$1;

            public final ControllerContext apply() {
                return this.controllerContext$1;
            }
            {
                this.controllerContext$1 = controllerContext$1;
            }
        }, (Function0<MetadataVersion>)new Serializable(config){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig config$1;

            public final MetadataVersion apply() {
                return this.config$1.interBrokerProtocolVersion();
            }
            {
                this.config$1 = config$1;
            }
        }, stateChangeLogger, false);
    }
}

