/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import java.util.regex.Pattern;

public class NewRelicNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;
    private static final Pattern INVALID_CHARACTERS_PATTERN = Pattern.compile("[^\\w:]");

    private static String toValidNewRelicString(String input) {
        return INVALID_CHARACTERS_PATTERN.matcher(input).replaceAll("_");
    }

    public NewRelicNamingConvention() {
        this(NamingConvention.camelCase);
    }

    public NewRelicNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return StringEscapeUtils.escapeJson((String)NewRelicNamingConvention.toValidNewRelicString(this.delegate.name(name, type, baseUnit)));
    }

    public String tagKey(String key) {
        return StringEscapeUtils.escapeJson((String)NewRelicNamingConvention.toValidNewRelicString(this.delegate.tagKey(key)));
    }

    public String tagValue(String value) {
        return StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
    }
}

