/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tirasa.connid.bundles.ldup.LdUpConnector;
import net.tirasa.connid.bundles.ldup.LdUpConstants;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObjectReference;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.schema.AttributeUsage;
import org.ldaptive.schema.ObjectClassType;
import org.ldaptive.schema.SchemaFactory;

public class LdUpSchemaOp
implements SchemaOp {
    protected static final Log LOG = Log.getLog(LdUpSchemaOp.class);
    protected final LdUpUtils ldUpUtils;
    protected Schema schema;

    protected static Optional<AttributeInfo> toAttributeInfo(org.ldaptive.schema.Schema ldapSchema, String attr, Optional<AttributeInfo.Flags> add) {
        return Optional.ofNullable(ldapSchema.getAttributeType(attr)).map(attrType -> {
            EnumSet<AttributeInfo.Flags> flags = EnumSet.noneOf(AttributeInfo.Flags.class);
            if (!attrType.isSingleValued()) {
                flags.add(AttributeInfo.Flags.MULTIVALUED);
            }
            if (attrType.isNoUserModification() || "objectClass".equalsIgnoreCase(attr)) {
                flags.add(AttributeInfo.Flags.NOT_CREATABLE);
                flags.add(AttributeInfo.Flags.NOT_UPDATEABLE);
            }
            if (attrType.getUsage() != AttributeUsage.USER_APPLICATIONS) {
                flags.add(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT);
            }
            add.ifPresent(flags::add);
            return AttributeInfoBuilder.build((String)attr, Arrays.binarySearch(ldapSchema.getBinaryAttributeNames(), attr) < 0 ? String.class : byte[].class, flags);
        });
    }

    public LdUpSchemaOp(LdUpUtils ldUpUtils) {
        this.ldUpUtils = ldUpUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema schema() {
        LdUpUtils ldUpUtils = this.ldUpUtils;
        synchronized (ldUpUtils) {
            if (this.schema == null) {
                SchemaBuilder schemaBld = new SchemaBuilder(LdUpConnector.class);
                try {
                    org.ldaptive.schema.Schema ldapSchema = SchemaFactory.createSchema((ConnectionFactory)this.ldUpUtils.getConnectionFactory());
                    ldapSchema.getObjectClasses().forEach(ldapClass -> {
                        ObjectClassInfoBuilder objClassBld = new ObjectClassInfoBuilder();
                        objClassBld.setType(ldapClass.getName());
                        objClassBld.setAuxiliary(ldapClass.getObjectClassType() == ObjectClassType.AUXILIARY);
                        objClassBld.setContainer(ldapClass.getObjectClassType() == ObjectClassType.STRUCTURAL);
                        Set required = Optional.ofNullable(ldapClass.getRequiredAttributes()).map(c -> Stream.of(c).collect(Collectors.toSet())).orElseGet(() -> Set.of());
                        Set optional = Optional.ofNullable(ldapClass.getOptionalAttributes()).map(c -> Stream.of(c).collect(Collectors.toSet())).orElseGet(() -> new HashSet());
                        optional.removeAll(required);
                        HashSet attrInfos = new HashSet();
                        required.forEach(attr -> LdUpSchemaOp.toAttributeInfo(ldapSchema, attr, Optional.of(AttributeInfo.Flags.REQUIRED)).ifPresentOrElse(attrInfos::add, () -> LOG.warn("Could not find attribute {0} in object classes {1}", new Object[]{attr, ldapClass.getName()})));
                        optional.forEach(attr -> LdUpSchemaOp.toAttributeInfo(ldapSchema, attr, Optional.empty()).ifPresentOrElse(attrInfos::add, () -> LOG.warn("Could not find attribute {0} in object classes {1}", new Object[]{attr, ldapClass.getName()})));
                        objClassBld.addAllAttributeInfo(attrInfos);
                        if (this.ldUpUtils.getConfiguration().getAccountObjectClass().equals(ldapClass.getName())) {
                            if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                                objClassBld.addAttributeInfo(new AttributeInfoBuilder("ldapGroups", String.class).setMultiValued(true).setReturnedByDefault(false).build());
                            } else {
                                objClassBld.addAttributeInfo(new AttributeInfoBuilder(PredefinedAttributes.GROUPS_NAME, ConnectorObjectReference.class).setReferencedObjectClassName(this.ldUpUtils.getConfiguration().getGroupObjectClass()).setRoleInReference(AttributeInfo.RoleInReference.SUBJECT.toString()).setMultiValued(true).setReturnedByDefault(false).build());
                            }
                        } else if (this.ldUpUtils.getConfiguration().getGroupObjectClass().equals(ldapClass.getName())) {
                            if (this.ldUpUtils.getConfiguration().isLegacyCompatibilityMode()) {
                                objClassBld.addAttributeInfo(new AttributeInfoBuilder(this.ldUpUtils.getConfiguration().getGroupMemberAttribute(), String.class).setMultiValued(true).setReturnedByDefault(false).build());
                            } else {
                                objClassBld.addAttributeInfo(new AttributeInfoBuilder(LdUpConstants.MEMBERS_ATTR_NAME, ConnectorObjectReference.class).setReferencedObjectClassName(this.ldUpUtils.getConfiguration().getAccountObjectClass()).setRoleInReference(AttributeInfo.RoleInReference.OBJECT.toString()).setMultiValued(true).setReturnedByDefault(false).build());
                            }
                        }
                        schemaBld.defineObjectClass(objClassBld.build());
                        if (this.ldUpUtils.getConfiguration().getAccountObjectClass().equals(ldapClass.getName())) {
                            objClassBld.setType(ObjectClass.ACCOUNT_NAME);
                            schemaBld.defineObjectClass(objClassBld.build());
                        } else if (this.ldUpUtils.getConfiguration().getGroupObjectClass().equals(ldapClass.getName())) {
                            objClassBld.setType(ObjectClass.GROUP_NAME);
                            schemaBld.defineObjectClass(objClassBld.build());
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "While building schema", new Object[0]);
                }
                this.schema = schemaBld.build();
            }
        }
        return this.schema;
    }
}

