/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;

public class IpAddressAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(IpAddressAuthorizationManager.class);
    private final CasConfigurationProperties casProperties;
    private final ActuatorEndpointProperties properties;

    public AuthorizationDecision check(Supplier authentication, RequestAuthorizationContext context) {
        String remoteAddr = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequest().getHeader(this.casProperties.getAudit().getEngine().getAlternateClientAddrHeaderName()), (CharSequence)context.getRequest().getRemoteAddr());
        boolean granted = this.properties.getRequiredIpAddresses().stream().anyMatch(pattern -> RegexUtils.matchesIpAddress((String)pattern, (String)remoteAddr));
        if (!granted) {
            LOGGER.warn("Provided regular expression or IP/netmask [{}] does not match [{}]", (Object)this.properties.getRequiredIpAddresses(), (Object)remoteAddr);
        }
        return new AuthorizationDecision(granted);
    }

    @Generated
    public IpAddressAuthorizationManager(CasConfigurationProperties casProperties, ActuatorEndpointProperties properties) {
        this.casProperties = casProperties;
        this.properties = properties;
    }
}

