/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.KeywordSearchEvent;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.CommandRestClient;
import org.apache.syncope.client.console.tasks.ExecMessage;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.CommandWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class CommandDirectoryPanel
extends DirectoryPanel<CommandTO, CommandTO, CommandDataProvider, CommandRestClient> {
    private static final long serialVersionUID = -8723262033772725592L;
    private String keyword;

    public CommandDirectoryPanel(String id, CommandRestClient restClient, PageReference pageRef) {
        super(id, restClient, pageRef);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.modal, true);
        this.addNewItemPanelBuilder(new CommandWizardBuilder(new CommandTO(), restClient, pageRef), false);
        this.setShowResultPanel(true);
        this.initResultTable();
    }

    @Override
    protected CommandDataProvider dataProvider() {
        return new CommandDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "command.paginator.rows";
    }

    @Override
    protected List<IColumn<CommandTO, String>> getColumns() {
        ArrayList<IColumn<CommandTO, String>> columns = new ArrayList<IColumn<CommandTO, String>>();
        columns.add((IColumn<CommandTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<CommandTO, String>)new AbstractColumn<CommandTO, String>((IModel)new ResourceModel("arguments"), "arguments"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<CommandTO>> cellItem, String componentId, IModel<CommandTO> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((CommandTO)rowModel.getObject()).getArgs().getClass().getName()))});
            }
        });
        return columns;
    }

    @Override
    protected ActionsPanel<CommandTO> getActions(final IModel<CommandTO> model) {
        ActionsPanel<CommandTO> panel = super.getActions(model);
        panel.add(new ActionLink<CommandTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, CommandTO ignore) {
                CommandDirectoryPanel.this.send((IEventSink)CommandDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((CommandTO)model.getObject()), target));
            }
        }, ActionLink.ActionType.EXECUTE, "COMMAND_RUN");
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected Panel customResultBody(String panelId, CommandTO item, Serializable result) {
        return new ExecMessage(panelId, (String)((Object)result));
    }

    @Override
    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof KeywordSearchEvent) {
            KeywordSearchEvent payload = (KeywordSearchEvent)object;
            this.keyword = payload.getKeyword();
            if (StringUtils.isNotBlank((CharSequence)this.keyword)) {
                if (!Strings.CS.startsWith((CharSequence)this.keyword, (CharSequence)"*")) {
                    this.keyword = "*" + this.keyword;
                }
                if (!Strings.CS.endsWith((CharSequence)this.keyword, (CharSequence)"*")) {
                    this.keyword = this.keyword + "*";
                }
            }
            this.updateResultTable(payload.getTarget());
        } else {
            super.onEvent(event);
        }
    }

    protected final class CommandDataProvider
    extends DirectoryDataProvider<CommandTO> {
        private static final long serialVersionUID = 6267494272884913376L;

        public CommandDataProvider(int paginatorRows) {
            super(paginatorRows);
        }

        public Iterator<CommandTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((CommandRestClient)CommandDirectoryPanel.this.restClient).search((page < 0 ? 0 : page) + 1, this.paginatorRows, CommandDirectoryPanel.this.keyword).iterator();
        }

        public long size() {
            return ((CommandRestClient)CommandDirectoryPanel.this.restClient).count(CommandDirectoryPanel.this.keyword);
        }

        public IModel<CommandTO> model(CommandTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

