/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.support;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.Factory;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import com.googlecode.cqengine.resultset.stored.StoredResultSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractMapBasedAttributeIndex<A, O, MapType extends ConcurrentMap<A, StoredResultSet<O>>>
extends AbstractAttributeIndex<A, O> {
    protected final Factory<MapType> indexMapFactory;
    protected final Factory<StoredResultSet<O>> valueSetFactory;
    protected final MapType indexMap;

    protected AbstractMapBasedAttributeIndex(Factory<MapType> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute, Set<Class<? extends Query>> supportedQueries) {
        super(attribute, supportedQueries);
        this.indexMapFactory = indexMapFactory;
        this.valueSetFactory = valueSetFactory;
        this.indexMap = (ConcurrentMap)indexMapFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            MapType indexMap = this.indexMap;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object attributeValue : attributeValues) {
                    StoredResultSet<O> existingValueSet;
                    StoredResultSet valueSet = (StoredResultSet)indexMap.get(attributeValue = this.getQuantizedValue(attributeValue));
                    if (valueSet == null && (existingValueSet = indexMap.putIfAbsent(attributeValue, valueSet = this.valueSetFactory.create())) != null) {
                        valueSet = existingValueSet;
                    }
                    modified |= valueSet.add(object);
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            MapType indexMap = this.indexMap;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object attributeValue : attributeValues) {
                    StoredResultSet valueSet = (StoredResultSet)indexMap.get(attributeValue = this.getQuantizedValue(attributeValue));
                    if (valueSet == null) continue;
                    modified |= valueSet.remove(object);
                    if (!valueSet.isEmpty()) continue;
                    indexMap.remove(attributeValue);
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, queryOptions), queryOptions);
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.indexMap.clear();
    }

    protected CloseableIterable<A> getDistinctKeys() {
        return AbstractMapBasedAttributeIndex.wrapNonCloseable(this.indexMap.keySet());
    }

    protected CloseableIterable<KeyValue<A, O>> getKeysAndValues() {
        return AbstractMapBasedAttributeIndex.wrapNonCloseable(IteratorUtil.flatten(this.indexMap));
    }

    protected static <T> CloseableIterable<T> wrapNonCloseable(final Iterable<T> iterable) {
        return new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return new CloseableIterator<T>(){
                    final Iterator<T> iterator;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.iterator.next();
                    }
                };
            }
        };
    }

    protected Integer getCountForKey(A key) {
        StoredResultSet objectsForKey = (StoredResultSet)this.indexMap.get(key);
        return objectsForKey == null ? 0 : objectsForKey.size();
    }

    protected Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return this.indexMap.keySet().size();
    }

    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        final Iterator distinctKeysIterator = this.indexMap.keySet().iterator();
        return AbstractMapBasedAttributeIndex.wrapNonCloseable(new Iterable<KeyStatistics<A>>(){

            @Override
            public Iterator<KeyStatistics<A>> iterator() {
                return new LazyIterator<KeyStatistics<A>>(){

                    protected KeyStatistics<A> computeNext() {
                        if (distinctKeysIterator.hasNext()) {
                            Object key = distinctKeysIterator.next();
                            return new KeyStatistics(key, AbstractMapBasedAttributeIndex.this.getCountForKey(key));
                        }
                        return (KeyStatistics)this.endOfData();
                    }
                };
            }
        });
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    protected A getQuantizedValue(A attributeValue) {
        return attributeValue;
    }
}

