/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.SAML2SPBeforeLogout;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2SPLogin
extends WebPage {
    private static final long serialVersionUID = 8581614051773949262L;
    private static final Logger LOG = LoggerFactory.getLogger(SAML2SPLogin.class);
    private static final String SAML_ACCESS_ERROR = "SAML 2.0 access error";

    public SAML2SPLogin(PageParameters parameters) {
        super(parameters);
        String jwt = parameters.get("saml2sp4ui.jwt").toOptionalString();
        Instant jwtExpiration = (Instant)parameters.get("saml2sp4ui.jwt.expiration").toOptional(Instant.class);
        if (StringUtils.isBlank((CharSequence)jwt)) {
            LOG.error("No JWT found, redirecting to default greeter");
            PageParameters loginParameters = new PageParameters();
            loginParameters.add("notificationMessage", (Object)SAML_ACCESS_ERROR);
            loginParameters.add("notificationLevel", (Object)"error");
            this.setResponsePage(Login.class, loginParameters);
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (SyncopeEnduserSession.get().authenticate(jwt, jwtExpiration)) {
            if (parameters.get("saml2sp4ui.sloSupported").toBoolean(false)) {
                SyncopeEnduserSession.get().setAttribute("beforeLogoutPage", SAML2SPBeforeLogout.class);
            }
            SyncopeEnduserSession.get().setLastReauth();
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            PageParameters loginParameters = new PageParameters();
            loginParameters.add("notificationMessage", (Object)SAML_ACCESS_ERROR);
            loginParameters.add("notificationLevel", (Object)"error");
            this.setResponsePage(Login.class, loginParameters);
        }
        strategy.remove();
    }
}

