/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.console.status;

import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.client.ui.commons.Constants;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class LinkedAccountStatusPanel extends RemoteObjectPanel {

    private static final long serialVersionUID = 7662852503618434902L;

    @SpringBean
    protected ReconStatusUtils reconStatusUtils;

    protected final String resource;

    protected final String anyTypeKey;

    protected final String connObjectKeyValue;

    public LinkedAccountStatusPanel(
            final String resource,
            final String anyTypeKey,
            final String connObjectKeyValue) {

        this.resource = resource;
        this.anyTypeKey = anyTypeKey;
        this.connObjectKeyValue = connObjectKeyValue;

        add(new ConnObjectPanel(
                REMOTE_OBJECT_PANEL_ID,
                Pair.of(Model.of(Constants.SYNCOPE), new ResourceModel("resource")),
                getStatusProviderInfo(),
                false));
    }

    @Override
    protected StatusProvider.Info getStatusProviderInfo() {
        Optional<ReconStatus> status = reconStatusUtils.getReconStatus(anyTypeKey, connObjectKeyValue, resource);

        return status.map(s -> new StatusProvider.Info(s.getOnSyncope(), s.getOnResource())).orElse(null);
    }
}
