/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class UrlResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlResourceMetadataResolver.class);
    private static final String FILENAME_EXTENSION_XML = ".xml";
    private static final String DIRNAME_METADATA_BACKUPS = "metadata-backups";
    private final HttpClient httpClient;
    private final File metadataBackupDirectory;

    public UrlResourceMetadataResolver(HttpClient httpClient, SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
        this.httpClient = httpClient;
        SamlIdPMetadataProperties md = samlIdPProperties.getMetadata();
        String backupLocation = (String)StringUtils.defaultIfBlank((CharSequence)md.getHttp().getMetadataBackupLocation(), (CharSequence)md.getFileSystem().getLocation());
        String location = SpringExpressionLanguageValueResolver.getInstance().resolve(backupLocation);
        this.metadataBackupDirectory = (File)FunctionUtils.doUnchecked(() -> new File(ResourceUtils.getRawResourceFrom((String)location).getFile(), DIRNAME_METADATA_BACKUPS));
        try {
            LOGGER.trace("Creating metadata backup directory at [{}]", (Object)this.metadataBackupDirectory);
            FileUtils.forceMkdir((File)this.metadataBackupDirectory);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create metadata backup directory [{}] to store downloaded metadata. This is likely due to a permission issue", (Object)this.metadataBackupDirectory);
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        HttpResponse response = null;
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)service);
            String metadataLocation = this.getMetadataLocationForService(service, criteriaSet);
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            UrlResource metadataResource = new UrlResource(metadataLocation);
            File backupFile = this.getMetadataBackupFile((AbstractResource)metadataResource, service);
            if (backupFile.exists() && this.samlIdPProperties.getMetadata().getHttp().isForceMetadataRefresh()) {
                this.cleanUpExpiredBackupMetadataFilesFor((AbstractResource)metadataResource, service);
            }
            String canonicalPath = backupFile.getCanonicalPath();
            LOGGER.debug("Metadata backup file will be at [{}]", (Object)canonicalPath);
            FileUtils.forceMkdirParent((File)backupFile);
            response = this.fetchMetadata(service, metadataLocation, criteriaSet, backupFile);
            HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (this.shouldHttpResponseStatusBeProcessed(status)) {
                AbstractMetadataResolver metadataProvider = this.getMetadataResolverFromResponse(response, backupFile);
                this.configureAndInitializeSingleMetadataResolver(metadataProvider, service);
                List list = CollectionUtils.wrap((Object)metadataProvider);
                HttpUtils.close((HttpResponse)response);
                return list;
            }
            HttpUtils.close((HttpResponse)response);
            return new ArrayList(0);
        }
        catch (UnauthorizedServiceException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new SamlException(e.getMessage(), (Throwable)e);
            catch (Exception e2) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e2);
                return new ArrayList(0);
            }
        }
        finally {
            HttpUtils.close(response);
        }
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = this.getMetadataLocationForService(service, new CriteriaSet());
            return StringUtils.isNotBlank((CharSequence)metadataLocation) && StringUtils.startsWith((CharSequence)metadataLocation, (CharSequence)"http") && !SamlUtils.isDynamicMetadataQueryConfigured((String)metadataLocation);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        if (this.supports(service)) {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            HttpStatus status = HttpRequestUtils.pingUrl((String)metadataLocation);
            return !status.isError();
        }
        return false;
    }

    protected boolean shouldHttpResponseStatusBeProcessed(HttpStatus status) {
        return status.is2xxSuccessful();
    }

    protected AbstractMetadataResolver getMetadataResolverFromResponse(HttpResponse response, File backupFile) throws Exception {
        HttpEntity entity = response.getEntity();
        String result = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
        Path path = backupFile.toPath();
        LOGGER.trace("Writing metadata to file at [{}]", (Object)path);
        try (BufferedWriter output = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            IOUtils.write((String)result, (Writer)output);
            output.flush();
        }
        EntityUtils.consume((HttpEntity)entity);
        return new InMemoryResourceMetadataResolver(backupFile, this.configBean);
    }

    protected HttpResponse fetchMetadata(SamlRegisteredService service, String metadataLocation, CriteriaSet criteriaSet, File backupFile) {
        LOGGER.debug("Fetching metadata from [{}]", (Object)metadataLocation);
        HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).url(metadataLocation).proxyUrl(service.getMetadataProxyLocation()).httpClient(this.httpClient).build();
        return HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
    }

    protected String getMetadataLocationForService(SamlRegisteredService service, CriteriaSet criteriaSet) {
        return SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
    }

    protected File getMetadataBackupFile(AbstractResource metadataResource, SamlRegisteredService service) throws IOException {
        LOGGER.debug("Metadata backup directory is at [{}]", (Object)this.metadataBackupDirectory.getCanonicalPath());
        String metadataFileName = this.getBackupMetadataFilenamePrefix(metadataResource, service).concat(FILENAME_EXTENSION_XML);
        File backupFile = new File(this.metadataBackupDirectory, metadataFileName);
        if (backupFile.exists()) {
            LOGGER.info("Metadata file designated for service [{}] already exists at path [{}].", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        } else {
            LOGGER.debug("Metadata to fetch for service [{}] will be placed at [{}]", (Object)service.getName(), (Object)backupFile.getCanonicalPath());
        }
        return backupFile;
    }

    protected String getBackupMetadataFilenamePrefix(AbstractResource metadataResource, SamlRegisteredService service) {
        String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
        String fileName = SamlUtils.isDynamicMetadataQueryConfigured((String)metadataLocation) ? service.getServiceId() : metadataLocation;
        String sha = DigestUtils.sha((String)fileName);
        LOGGER.trace("Metadata backup file for metadata location [{}] is linked to [{}]", (Object)fileName, (Object)sha);
        return sha;
    }

    private void cleanUpExpiredBackupMetadataFilesFor(AbstractResource metadataResource, SamlRegisteredService service) {
        String prefix = this.getBackupMetadataFilenamePrefix(metadataResource, service);
        Collection backups = FileUtils.listFiles((File)this.metadataBackupDirectory, (IOFileFilter)new AndFileFilter(CollectionUtils.wrapList((Object[])new IOFileFilter[]{new PrefixFileFilter(prefix, IOCase.INSENSITIVE), new SuffixFileFilter(FILENAME_EXTENSION_XML, IOCase.INSENSITIVE), CanWriteFileFilter.CAN_WRITE, CanReadFileFilter.CAN_READ})), (IOFileFilter)TrueFileFilter.INSTANCE);
        backups.forEach(Unchecked.consumer(FileUtils::forceDelete));
    }
}

