/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.attributes.validation.AttributeValidator;
import org.apache.commons.attributes.validation.ValidationException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AttributeValidatorTask
extends Task {
    private File jarFile;
    private List classes = new ArrayList();
    private List validators = new ArrayList();
    private Path classPath;
    private File baseName;
    private boolean inMaven = false;
    private static final String SUFFIX = "$__attributeRepository.class";

    public void setJarfile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setBaseName(File baseName) {
        this.inMaven = true;
        this.baseName = baseName;
    }

    public Path createClasspath() {
        this.classPath = new Path(((ProjectComponent)this).project);
        return this.classPath;
    }

    public Validator createValidator() {
        Validator validator = new Validator();
        this.validators.add(validator);
        return validator;
    }

    protected void findJarFile() throws BuildException {
        File[] allFiles = this.baseName.getParentFile().listFiles();
        if (allFiles == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
        long newestDate = 0L;
        int i = 0;
        while (i < allFiles.length) {
            String name = allFiles[i].getName();
            if (name.startsWith(this.baseName.getName()) && name.endsWith(".jar") && allFiles[i].lastModified() > newestDate) {
                this.jarFile = allFiles[i];
                newestDate = allFiles[i].lastModified();
            }
            ++i;
        }
        if (this.jarFile == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.inMaven) {
            this.findJarFile();
        }
        if (!this.jarFile.exists()) {
            this.log("Can't find " + this.jarFile.getPath());
            return;
        }
        try {
            this.log("Validating attributes in " + this.jarFile.getPath());
            JarFile jar = new JarFile(this.jarFile);
            try {
                Enumeration<JarEntry> enumeration = jar.entries();
                while (enumeration.hasMoreElements()) {
                    String className;
                    JarEntry entry = enumeration.nextElement();
                    if (entry.isDirectory() || !(className = entry.getName()).endsWith(SUFFIX)) continue;
                    className = className.replace('/', '.').replace('\\', '.').substring(0, className.length() - SUFFIX.length());
                    this.classes.add(className);
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                jar.close();
                throw throwable;
            }
            jar.close();
            AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), ((ProjectComponent)this).project, this.classPath, true);
            try {
                cl.addPathElement(this.jarFile.getPath());
                HashSet classesToValidate = new HashSet();
                Iterator attrs = this.classes.iterator();
                while (attrs.hasNext()) {
                    String className = (String)attrs.next();
                    Class<?> clazz = cl.loadClass(className);
                    classesToValidate.add(clazz);
                }
                Iterator iter = this.validators.iterator();
                while (iter.hasNext()) {
                    Validator validator = (Validator)iter.next();
                    Class<?> validatorClass = cl.loadClass(validator.getClassName());
                    AttributeValidator attrValidator = (AttributeValidator)validatorClass.newInstance();
                    try {
                        attrValidator.validate(classesToValidate);
                    }
                    catch (ValidationException ve) {
                        throw new BuildException(ve.getInvalidClass() + " failed to validate: " + ve.getMessage());
                    }
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                cl.cleanup();
                throw throwable;
            }
            cl.cleanup();
            {
            }
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
    }

    static {
        SUFFIX = SUFFIX;
    }

    public static class Validator {
        private String className;

        public void setClass(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

