/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ServicesManagerRegisteredServiceLocator
extends DefaultServicesManagerRegisteredServiceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ServicesManagerRegisteredServiceLocator.class);
    protected final CasConfigurationProperties casProperties;

    public OAuth20ServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
        this.setOrder(Integer.MIN_VALUE);
        this.setRegisteredServiceFilter((registeredService, service) -> {
            boolean match = this.supports((RegisteredService)registeredService, (Service)service);
            if (match) {
                OAuthRegisteredService oauthService = (OAuthRegisteredService)registeredService;
                LOGGER.trace("Attempting to locate service [{}] via [{}]", service, (Object)oauthService);
                match = CollectionUtils.firstElement(service.getAttributes().get("client_id")).map(Object::toString).stream().anyMatch(clientId -> oauthService.getClientId().equalsIgnoreCase((String)clientId));
            }
            return match;
        });
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        return registeredService instanceof OAuthRegisteredService && this.supportsInternal(registeredService, service);
    }

    protected boolean supportsInternal(RegisteredService registeredService, Service givenService) {
        Map attributes = givenService.getAttributes();
        if (attributes.containsKey("client_id")) {
            WebApplicationService service = (WebApplicationService)givenService;
            String source = CollectionUtils.firstElement(attributes.get(service.getSource())).map(String.class::cast).orElse("");
            String callbackService = OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix());
            return StringUtils.isBlank((CharSequence)source) || StringUtils.startsWith((CharSequence)source, (CharSequence)callbackService) || OAuth20Utils.checkCallbackValid(registeredService, source);
        }
        return false;
    }
}

