/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Pattern;

public class PackageLocator {
    private static final Pattern PATTERN_DOT = Pattern.compile("\\.");
    private final ClassPropertyAccessor classPropertyAccessor;

    public PackageLocator() {
        this(new ClassPropertyAccessor());
    }

    PackageLocator(ClassPropertyAccessor classPropertyAccessor) {
        this.classPropertyAccessor = classPropertyAccessor;
    }

    public File locatePackage(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz was null");
        }
        File classFilePath = this.getClasspathFromProtectionDomain(clazz);
        if (classFilePath == null) {
            classFilePath = this.getClasspathFromResource(clazz);
        }
        return classFilePath;
    }

    private File getClasspathFromProtectionDomain(Class clazz) throws SecurityException {
        ProtectionDomain protectionDomain;
        try {
            protectionDomain = this.classPropertyAccessor.getProtectionDomain(clazz);
        }
        catch (SecurityException ignored) {
            return null;
        }
        if (protectionDomain == null) {
            throw new Error("Unable to determine the ProtectionDomain for the specified class");
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            throw new Error("ProtectionDomain returned a null CodeSource");
        }
        URL resourceUrl = codeSource.getLocation();
        if (resourceUrl == null) {
            return null;
        }
        String canonicalName = this.classPropertyAccessor.getCanonicalName(clazz);
        File result = PackageLocator.getClasspathFromUrl(resourceUrl, canonicalName);
        return result;
    }

    private File getClasspathFromResource(Class clazz) {
        String name = this.classPropertyAccessor.getSimpleName(clazz) + ".class";
        URL resourceUrl = this.classPropertyAccessor.getResource(clazz, name);
        if (resourceUrl == null) {
            throw new Error("A null resource URL was returned by getResource");
        }
        String canonicalName = this.classPropertyAccessor.getCanonicalName(clazz);
        File result = PackageLocator.getClasspathFromUrl(resourceUrl, canonicalName);
        return result;
    }

    static File getClasspathFromUrl(URL resourceUrl, String canonicalName) {
        File result;
        String resourcePath;
        if (resourceUrl == null) {
            throw new IllegalArgumentException("resourceUrl must not be null");
        }
        if (canonicalName == null) {
            throw new IllegalArgumentException("canonicalName must not be null");
        }
        try {
            URI resourceUri = resourceUrl.toURI();
            URI schemeStrippedUri = PackageLocator.stripSchemes(resourceUri);
            resourcePath = schemeStrippedUri.getPath();
        }
        catch (URISyntaxException ignored) {
            resourcePath = resourceUrl.getPath();
        }
        String slashedName = PATTERN_DOT.matcher(canonicalName).replaceAll("/");
        String pathToClassFile = "/" + slashedName + ".class";
        int lastIndexOfClassName = resourcePath.lastIndexOf(pathToClassFile);
        if (lastIndexOfClassName > 0) {
            int mark = resourcePath.charAt(lastIndexOfClassName - 1) == '!' ? lastIndexOfClassName - 1 : lastIndexOfClassName;
            String resourcePathMinusSuffix = resourcePath.substring(0, mark);
            result = new File(resourcePathMinusSuffix);
        } else {
            result = new File(resourcePath);
        }
        return result;
    }

    static URI stripSchemes(URI uri) {
        URI schemeStrippedUri = uri;
        while (schemeStrippedUri.getScheme() != null) {
            schemeStrippedUri = URI.create(schemeStrippedUri.getRawSchemeSpecificPart());
        }
        return schemeStrippedUri;
    }

    static class ClassPropertyAccessor {
        ClassPropertyAccessor() {
        }

        public ProtectionDomain getProtectionDomain(Class clazz) throws SecurityException {
            return clazz.getProtectionDomain();
        }

        public URL getResource(Class clazz, String resourceName) {
            return clazz.getResource(resourceName);
        }

        public String getCanonicalName(Class clazz) {
            return clazz.getCanonicalName();
        }

        public String getSimpleName(Class clazz) {
            return clazz.getSimpleName();
        }
    }
}

