/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCC4UIProviderDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIEntityFactory;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIUserTemplate;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.data.OIDCC4UIProviderDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCC4UIProviderDataBinderImpl
implements OIDCC4UIProviderDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCC4UIProviderDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final OIDCC4UIProviderDAO oidcOPDAO;
    protected final ImplementationDAO implementationDAO;
    protected final OIDCC4UIEntityFactory entityFactory;
    protected final IntAttrNameParser intAttrNameParser;

    public OIDCC4UIProviderDataBinderImpl(AnyTypeDAO anyTypeDAO, OIDCC4UIProviderDAO oidcOPDAO, ImplementationDAO implementationDAO, OIDCC4UIEntityFactory entityFactory, IntAttrNameParser intAttrNameParser) {
        this.anyTypeDAO = anyTypeDAO;
        this.oidcOPDAO = oidcOPDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
        this.intAttrNameParser = intAttrNameParser;
    }

    public OIDCC4UIProvider create(OIDCC4UIProviderTO opTO) {
        return this.update((OIDCC4UIProvider)this.entityFactory.newEntity(OIDCC4UIProvider.class), opTO);
    }

    protected void populateItems(OIDCC4UIProviderTO opTO, OIDCC4UIProvider op) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        opTO.getItems().forEach(itemTO -> {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)Item.class.getSimpleName());
                invalidMapping.getElements().add("Null " + Item.class.getSimpleName());
            } else if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
            } else {
                IntAttrName intAttrName = null;
                try {
                    intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), AnyTypeKind.USER);
                }
                catch (ParseException e) {
                    LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)itemTO.getIntAttrName(), (Object)e);
                }
                if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null) {
                    LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                    invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not existing");
                } else {
                    if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                        SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                        invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                        scce.addException(invalidMandatoryCondition);
                    }
                    Item item = new Item();
                    item.setIntAttrName(itemTO.getIntAttrName());
                    item.setExtAttrName(itemTO.getExtAttrName());
                    item.setMandatoryCondition(itemTO.getMandatoryCondition());
                    item.setConnObjectKey(itemTO.isConnObjectKey());
                    item.setPassword(itemTO.isPassword());
                    item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                    item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                    item.setPurpose(MappingPurpose.NONE);
                    itemTO.getTransformers().forEach(transformerKey -> {
                        Implementation transformer = this.implementationDAO.find(transformerKey);
                        if (transformer == null) {
                            LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", transformerKey);
                        } else {
                            item.getTransformers().add(transformer.getKey());
                        }
                        item.getTransformers().removeIf(implementation -> !itemTO.getTransformers().contains(implementation));
                    });
                    if (item.isConnObjectKey()) {
                        if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                            invalidMapping.getElements().add("Virtual attributes cannot be set as ConnObjectKey");
                        }
                        if ("password".equals(intAttrName.getField())) {
                            invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                        }
                        op.setConnObjectKeyItem(item);
                    } else {
                        op.getItems().add(item);
                    }
                }
            }
        });
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public OIDCC4UIProvider update(OIDCC4UIProvider op, OIDCC4UIProviderTO opTO) {
        op.setAuthorizationEndpoint(opTO.getAuthorizationEndpoint());
        op.setClientID(opTO.getClientID());
        op.setClientSecret(opTO.getClientSecret());
        op.setName(opTO.getName());
        op.setIssuer(opTO.getIssuer());
        op.setJwksUri(opTO.getJwksUri());
        op.setTokenEndpoint(opTO.getTokenEndpoint());
        op.setUserinfoEndpoint(opTO.getUserinfoEndpoint());
        op.setEndSessionEndpoint(opTO.getEndSessionEndpoint());
        op.setScopes(opTO.getScopes());
        op.setHasDiscovery(opTO.getHasDiscovery());
        op.setCreateUnmatching(opTO.isCreateUnmatching());
        op.setSelfRegUnmatching(opTO.isSelfRegUnmatching());
        op.setUpdateMatching(opTO.isUpdateMatching());
        if (opTO.getUserTemplate() == null) {
            op.setUserTemplate(null);
        } else {
            OIDCC4UIUserTemplate userTemplate = op.getUserTemplate();
            if (userTemplate == null) {
                userTemplate = (OIDCC4UIUserTemplate)this.entityFactory.newEntity(OIDCC4UIUserTemplate.class);
                userTemplate.setAnyType(this.anyTypeDAO.findUser());
                userTemplate.setOP(op);
                op.setUserTemplate(userTemplate);
            }
            userTemplate.set((AnyTO)opTO.getUserTemplate());
        }
        op.getItems().clear();
        this.populateItems(opTO, op);
        opTO.getActions().forEach(action -> {
            Implementation implementation = this.implementationDAO.find(action);
            if (implementation == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", action);
            } else {
                op.add(implementation);
            }
        });
        op.getActions().removeIf(impl -> !opTO.getActions().contains(impl.getKey()));
        return this.oidcOPDAO.save(op);
    }

    protected static void populateItems(OIDCC4UIProvider op, OIDCC4UIProviderTO opTO) {
        op.getItems().forEach(item -> {
            Item itemTO = new Item();
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            itemTO.getTransformers().addAll(item.getTransformers());
            itemTO.setPurpose(MappingPurpose.NONE);
            if (itemTO.isConnObjectKey()) {
                opTO.setConnObjectKeyItem(itemTO);
            } else {
                opTO.add(itemTO);
            }
        });
    }

    public OIDCC4UIProviderTO getOIDCProviderTO(OIDCC4UIProvider op) {
        OIDCC4UIProviderTO opTO = new OIDCC4UIProviderTO();
        opTO.setKey(op.getKey());
        opTO.setAuthorizationEndpoint(op.getAuthorizationEndpoint());
        opTO.setClientID(op.getClientID());
        opTO.setClientSecret(op.getClientSecret());
        opTO.setName(op.getName());
        opTO.setIssuer(op.getIssuer());
        opTO.setJwksUri(op.getJwksUri());
        opTO.setTokenEndpoint(op.getTokenEndpoint());
        opTO.setUserinfoEndpoint(op.getUserinfoEndpoint());
        opTO.setEndSessionEndpoint(op.getEndSessionEndpoint());
        opTO.getScopes().addAll(op.getScopes());
        opTO.setHasDiscovery(op.getHasDiscovery());
        opTO.setCreateUnmatching(op.isCreateUnmatching());
        opTO.setSelfRegUnmatching(op.isSelfRegUnmatching());
        opTO.setUpdateMatching(op.isUpdateMatching());
        if (op.getUserTemplate() != null) {
            opTO.setUserTemplate((UserTO)op.getUserTemplate().get());
        }
        OIDCC4UIProviderDataBinderImpl.populateItems(op, opTO);
        opTO.getActions().addAll(op.getActions().stream().map(Entity::getKey).collect(Collectors.toList()));
        return opTO;
    }
}

