/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

public class ForgotUsernameWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public ForgotUsernameWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null && this.casProperties.getAuthn().getPm().getCore().isEnabled()) {
            this.createPasswordResetFlow();
        }
    }

    private void createPasswordResetFlow() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ViewState state = (ViewState)this.getState(flow, "viewLoginForm", ViewState.class);
            this.createTransitionForState((TransitionableState)state, "forgotUsername", "casForgotUsernameSendInfoView");
            ViewState usernameInfo = this.createViewState(flow, "casForgotUsernameSendInfoView", "forgot-username/casForgotUsernameSendInfoView");
            this.createTransitionForState((TransitionableState)usernameInfo, "findUsername", "sendForgotUsernameInstructions");
            ActionState sendUsernameInst = this.createActionState(flow, "sendForgotUsernameInstructions", new String[]{"sendForgotUsernameInstructionsAction"});
            this.createTransitionForState((TransitionableState)sendUsernameInst, "success", "casForgotUsernameSentInfoView");
            this.createTransitionForState((TransitionableState)sendUsernameInst, "error", usernameInfo.getId());
            this.createViewState(flow, "casForgotUsernameSentInfoView", "forgot-username/casForgotUsernameSentInfoView");
        }
    }
}

