/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.FeatureConfiguration;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ParseCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationError;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class Validation {
    private FeatureConfiguration featureConfiguration;
    private Collection<? extends ValidationCapability> capabilities;
    private List<String> statementsList;
    private List<ValidationError> errors;
    private Statements parsedStatements;

    public Validation(Collection<? extends ValidationCapability> collection, String ... stringArray) {
        this(new FeatureConfiguration(), collection, stringArray);
    }

    public Validation(FeatureConfiguration featureConfiguration, Collection<? extends ValidationCapability> collection, String ... stringArray) {
        this.featureConfiguration = featureConfiguration;
        this.capabilities = collection;
        this.statementsList = Arrays.asList(stringArray);
    }

    public List<ValidationError> validate() {
        this.errors = new ArrayList<ValidationError>();
        ValidationContext validationContext = Validation.createValidationContext(this.featureConfiguration, this.capabilities);
        for (String string : this.statementsList) {
            ParseCapability parseCapability = new ParseCapability(string);
            parseCapability.validate(validationContext, validationException -> this.errors.add(new ValidationError(string).withCapability(parseCapability).addError((ValidationException)validationException)));
            this.parsedStatements = parseCapability.getParsedStatements();
            if (this.parsedStatements == null || this.parsedStatements.getStatements() == null || this.capabilities.isEmpty()) continue;
            for (Statement statement : this.parsedStatements.getStatements()) {
                Map<ValidationCapability, Set<ValidationException>> map = Validation.validate(statement, validationContext);
                this.errors.addAll(Validation.toValidationErrors(string, statement, map));
            }
        }
        return this.errors;
    }

    public FeatureConfiguration getFeatureConfiguration() {
        return this.featureConfiguration;
    }

    public Collection<? extends ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getStatements() {
        return this.statementsList;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public Statements getParsedStatements() {
        return this.parsedStatements;
    }

    public static List<ValidationError> validate(Collection<? extends ValidationCapability> collection, String ... stringArray) {
        return new Validation(collection, stringArray).validate();
    }

    public static ValidationContext createValidationContext(FeatureConfiguration featureConfiguration, Collection<? extends ValidationCapability> collection) {
        ValidationContext validationContext = new ValidationContext();
        validationContext.setCapabilities(new ArrayList<ValidationCapability>(collection));
        validationContext.setConfiguration(featureConfiguration);
        return validationContext;
    }

    public static List<ValidationError> toValidationErrors(String string, Statement statement, Map<ValidationCapability, Set<ValidationException>> object) {
        ArrayList<ValidationError> arrayList = new ArrayList<ValidationError>();
        for (Map.Entry entry : object.entrySet()) {
            arrayList.add(new ValidationError(string).withParsedStatement(statement).withCapability((ValidationCapability)entry.getKey()).addErrors((Collection)entry.getValue()));
        }
        return arrayList;
    }

    public static Map<ValidationCapability, Set<ValidationException>> validate(Statement statement, ValidationContext validationContext) {
        StatementValidator statementValidator = new StatementValidator();
        statementValidator.setContext(validationContext);
        statementValidator.validate(statement);
        return statementValidator.getValidationErrors();
    }
}

