/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.entity.FIQLQuery;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAFIQLQuery;

public class JPAFIQLQueryDAO
extends AbstractDAO<FIQLQuery>
implements FIQLQueryDAO {
    public FIQLQuery find(String key) {
        return (FIQLQuery)this.entityManager().find(JPAFIQLQuery.class, (Object)key);
    }

    public List<FIQLQuery> findByOwner(User user, String target) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAFIQLQuery.class.getSimpleName()).append(" e WHERE e.owner=:user");
        if (StringUtils.isNotBlank((CharSequence)target)) {
            queryString.append(" AND e.target=:target");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), FIQLQuery.class);
        query.setParameter("user", (Object)user);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            query.setParameter("target", (Object)target);
        }
        return query.getResultList();
    }

    public List<FIQLQuery> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAFIQLQuery.class.getSimpleName() + " e ", FIQLQuery.class);
        return query.getResultList();
    }

    public FIQLQuery save(FIQLQuery fiqlQuery) {
        return (FIQLQuery)this.entityManager().merge((Object)fiqlQuery);
    }

    public void delete(FIQLQuery fiqlQuery) {
        this.entityManager().remove((Object)fiqlQuery);
    }

    public void delete(String key) {
        FIQLQuery fiqlQuery = this.find(key);
        if (fiqlQuery == null) {
            return;
        }
        this.delete(fiqlQuery);
    }
}

