/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAApplication;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;

public class JPAApplicationDAO
extends AbstractDAO<Application>
implements ApplicationDAO {
    protected final RoleDAO roleDAO;
    protected final UserDAO userDAO;

    public JPAApplicationDAO(RoleDAO roleDAO, UserDAO userDAO) {
        this.roleDAO = roleDAO;
        this.userDAO = userDAO;
    }

    public Application find(String key) {
        return (Application)this.entityManager().find(JPAApplication.class, (Object)key);
    }

    public Privilege findPrivilege(String key) {
        return (Privilege)this.entityManager().find(JPAPrivilege.class, (Object)key);
    }

    public List<Application> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAApplication.class.getSimpleName() + " e ", Application.class);
        return query.getResultList();
    }

    public Application save(Application application) {
        return (Application)this.entityManager().merge((Object)application);
    }

    public void delete(Application application) {
        application.getPrivileges().forEach(privilege -> {
            this.roleDAO.findByPrivilege(privilege).forEach(role -> role.getPrivileges().remove(privilege));
            this.userDAO.findLinkedAccountsByPrivilege(privilege).forEach(account -> account.getPrivileges().remove(privilege));
            privilege.setApplication(null);
        });
        application.getPrivileges().clear();
        this.entityManager().remove((Object)application);
    }

    public void delete(String key) {
        Application application = this.find(key);
        if (application == null) {
            return;
        }
        this.delete(application);
    }
}

