/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapAjaxButton
extends AjaxButton
implements IBootstrapButton<BootstrapAjaxButton> {
    private static final long serialVersionUID = 1L;
    private Icon icon;
    private Component label;
    private Component splitter;
    private ButtonBehavior buttonBehavior;
    private boolean useSplitter = true;
    private final Buttons.Type type;

    public BootstrapAjaxButton(String componentId, Buttons.Type type) {
        this(componentId, (IModel<String>)new Model(), type);
    }

    public BootstrapAjaxButton(String componentId, IModel<String> model, Buttons.Type type) {
        this(componentId, model, null, type);
    }

    public BootstrapAjaxButton(String id, Form<?> form, Buttons.Type type) {
        this(id, (IModel<String>)Model.of(), form, type);
    }

    public BootstrapAjaxButton(String id, IModel<String> model, Form<?> form, Buttons.Type type) {
        super(id, model, form);
        this.type = type;
        this.add(new Behavior[]{this.getButtonBehavior()});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getIcon(), this.getSplitter(), this.getButtonLabel()});
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(this.type, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newIcon("icon");
        }
        return this.icon;
    }

    private Component getSplitter() {
        if (this.splitter == null) {
            this.splitter = this.newSplitter("splitter");
        }
        return this.splitter;
    }

    private Component getButtonLabel() {
        if (this.label == null) {
            this.label = this.newLabel("label", this.getModel());
        }
        return this.label;
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected <L extends Serializable> Component newLabel(String markupId, IModel<L> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false).setVisible(false);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useSplitter) {
            this.getSplitter().setVisible(this.getIcon().hasIconType() && StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getModelObject())));
        }
    }

    public BootstrapAjaxButton setLabel(IModel<String> label) {
        this.getButtonLabel().setDefaultModel(label);
        this.setModel(label);
        return this;
    }

    public BootstrapAjaxButton setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    @Override
    public BootstrapAjaxButton setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    @Override
    public BootstrapAjaxButton setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public BootstrapAjaxButton useSplitter(boolean value) {
        this.useSplitter = value;
        return this;
    }

    public BootstrapAjaxButton setBlock(boolean block) {
        this.getButtonBehavior().setBlock(block);
        return this;
    }
}

