/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.editor;

import com.google.common.collect.Lists;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteStorage;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.lang.Bytes;

public class SummernoteConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_OVERLAY_TIMEOUT = (int)Duration.ofSeconds(2L).toMillis();
    private static final int DEFAULT_MAX_SIZE = (int)Bytes.megabytes((long)2L).bytes();
    public static final IKey<String> Id = SummernoteConfig.newKey((String)"summernoteEditorId", null);
    private static final IKey<Boolean> AirMode = SummernoteConfig.newKey((String)"airMode", null);
    private static final IKey<Integer> MaxHeight = SummernoteConfig.newKey((String)"maxHeight", null);
    private static final IKey<Integer> MinHeight = SummernoteConfig.newKey((String)"minHeight", null);
    private static final IKey<Integer> Height = SummernoteConfig.newKey((String)"height", null);
    private static final IKey<Boolean> Force = SummernoteConfig.newKey((String)"force", null);
    private static final IKey<Boolean> DisableDragDrop = SummernoteConfig.newKey((String)"disableDragAndDrop", (Object)false);
    private static final IKey<Boolean> Shortcuts = SummernoteConfig.newKey((String)"shortcuts", (Object)true);
    private static final IKey<Integer> MaxFileSize = SummernoteConfig.newKey((String)"maxFilesize", null);
    private static final IKey<String> ImageUploadCallbackUrl = SummernoteConfig.newKey((String)"imageUploadUrl", null);
    private static final IKey<String> Placeholder = SummernoteConfig.newKey((String)"placeholder", null);
    private static final IKey<Integer> OverlayTimeout = SummernoteConfig.newKey((String)"overlayTimeout", null);
    private static Set<SummernoteStorage> storages = new HashSet<SummernoteStorage>();
    private String storageId;
    private static final IKey<Map<String, List<String>>> ToolbarOptions = SummernoteConfig.newKey((String)"ToolbarOptions", null);
    private Map<String, List<String>> toolbarOptions = new LinkedHashMap<String, List<String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Style", Lists.newArrayList((Object[])new String[]{"style", "fontname", "fontsize", "color", "bold", "italic", "underline", "strikethrough", "clear"}));
            this.put("Layout", Lists.newArrayList((Object[])new String[]{"ul", "ol", "paragraph", "height"}));
            this.put("Insert", Lists.newArrayList((Object[])new String[]{"picture", "link", "video", "table", "hr"}));
            this.put("Misc", Lists.newArrayList((Object[])new String[]{"fullscreen", "codeview", "undo", "redo", "help"}));
        }
    };

    public SummernoteConfig() {
        this.put(ToolbarOptions, this.toolbarOptions);
        this.put(OverlayTimeout, DEFAULT_OVERLAY_TIMEOUT);
        this.put(MaxFileSize, DEFAULT_MAX_SIZE);
    }

    public SummernoteConfig withAirMode(boolean airMode) {
        this.put(AirMode, airMode);
        return this;
    }

    public boolean isAirMode() {
        return (Boolean)this.get(AirMode);
    }

    public SummernoteConfig withDisableDragAndDrop(boolean disableDragAndDrop) {
        this.put(DisableDragDrop, disableDragAndDrop);
        return this;
    }

    public SummernoteConfig withShortcuts(boolean shortcuts) {
        this.put(Shortcuts, shortcuts);
        return this;
    }

    public SummernoteConfig withMaxHeight(Integer maxHeight) {
        this.put(MaxHeight, maxHeight);
        return this;
    }

    public SummernoteConfig withMinHeight(Integer minHeight) {
        this.put(MinHeight, minHeight);
        return this;
    }

    public SummernoteConfig withHeight(Integer height) {
        this.put(Height, height);
        return this;
    }

    public SummernoteConfig withOverlayTimeout(Integer overlayTimeout) {
        this.put(OverlayTimeout, overlayTimeout);
        return this;
    }

    public SummernoteConfig force(boolean force) {
        this.put(Force, force);
        return this;
    }

    public SummernoteConfig withMaxFileSize(int maxFileSize) {
        this.put(MaxFileSize, maxFileSize);
        return this;
    }

    public int getMaxFileSize() {
        return (Integer)this.get(MaxFileSize);
    }

    public SummernoteConfig withImageUploadCallbackUrl(String callbackUrl) {
        this.put(ImageUploadCallbackUrl, callbackUrl);
        return this;
    }

    public SummernoteConfig withPlaceholder(String placeholder) {
        this.put(Placeholder, placeholder);
        return this;
    }

    public static SummernoteStorage getStorage(String storageId) {
        for (SummernoteStorage storage : storages) {
            if (!storage.getId().equals(storageId)) continue;
            return storage;
        }
        throw new WicketRuntimeException("Cannot find a storage with id: " + storageId + ". Use #addStorage(SummernoteStorage) to setup it.");
    }

    public static void addStorage(SummernoteStorage storage) {
        storages.add(storage);
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void useStorageId(String storageId) {
        this.storageId = storageId;
    }

    public List<String> getButtons(String category) {
        return this.toolbarOptions.get(category);
    }

    public void addButtons(String category, List<String> buttonIds) {
        this.toolbarOptions.put(category, buttonIds);
    }

    public void removeButtons(String category) {
        this.toolbarOptions.remove(category);
    }

    public String getImageNamePrefix() {
        return UUID.randomUUID().toString();
    }
}

