/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.time.Duration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.api.ExternalWorkerJobFailureBuilder;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.cmd.ExternalWorkerJobFailCmd;

public class ExternalWorkerJobFailureBuilderImpl
implements ExternalWorkerJobFailureBuilder {
    protected final String externalJobId;
    protected final String workerId;
    protected final CommandExecutor commandExecutor;
    protected final JobServiceConfiguration jobServiceConfiguration;
    protected String errorMessage;
    protected String errorDetails;
    protected int retries = -1;
    protected Duration retryTimeout;

    public ExternalWorkerJobFailureBuilderImpl(String externalJobId, String workerId, CommandExecutor commandExecutor, JobServiceConfiguration jobServiceConfiguration) {
        this.externalJobId = externalJobId;
        this.workerId = workerId;
        this.commandExecutor = commandExecutor;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public ExternalWorkerJobFailureBuilder errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public ExternalWorkerJobFailureBuilder errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public ExternalWorkerJobFailureBuilder retries(int retries) {
        this.retries = retries;
        return this;
    }

    public ExternalWorkerJobFailureBuilder retryTimeout(Duration retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public void fail() {
        this.commandExecutor.execute((Command)new ExternalWorkerJobFailCmd(this.externalJobId, this.workerId, this.retries, this.retryTimeout, this.errorMessage, this.errorDetails, this.jobServiceConfiguration));
    }
}

