/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.html;

import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.jquery.util.Generics2;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MetaTag
extends WebMarkupContainer
implements IGenericComponent<String, MetaTag> {
    private static final List<String> HTTP_EQUIV_NAMES = Generics2.newArrayList((Object[])new String[]{"content-type", "expires", "refresh", "pragma", "cache-control", "content-language", "set-cookie", "PICS-Label", "content-script-type", "content-style-type", "last-modified", "date", "location", "window-target"});
    private static final Pattern OGP_PROPERTIES = Pattern.compile("^(og|music|video|article|book|profile):.+");
    private static final String ATTRIBUTE_NAME_DEFAULT = "name";
    private static final String ATTRIBUTE_NAME_HTTPEQUIV = "http-equiv";
    static final String ATTRIBUTE_NAME_PROPERTY = "property";
    static final String ATTRIBUTE_NAME_CONTENT = "content";
    private final IModel<String> name;
    private Type type;

    @Deprecated
    public MetaTag(String id, String name) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)name)));
    }

    @Deprecated
    public MetaTag(String id, IModel<String> name) {
        this(id, name, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public MetaTag(String id, String name, String content) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)name)), (IModel<String>)Model.of((Serializable)((Object)content)));
    }

    public MetaTag(String id, IModel<String> name, IModel<String> content) {
        super(id, content);
        this.name = name;
        this.type = Type.Detect;
    }

    private Type detect(String name) {
        if (HTTP_EQUIV_NAMES.contains(Strings2.nullToEmpty((String)name).toLowerCase())) {
            return Type.HttpEquiv;
        }
        if (OGP_PROPERTIES.matcher(Strings2.nullToEmpty((String)name)).matches()) {
            return Type.Property;
        }
        return Type.Default;
    }

    public MetaTag type(Type type) {
        this.type = type;
        return this;
    }

    public final Type type() {
        if (Type.Detect.equals((Object)this.type)) {
            this.type = this.detect(this.name());
        }
        return this.type;
    }

    public String name() {
        return (String)this.name.getObject();
    }

    public String content() {
        return (String)this.getModelObject();
    }

    @Deprecated
    public MetaTag content(String content) {
        this.setModelObject(content);
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "meta");
        String nameAttribute = this.type().nameAttribute;
        tag.put(nameAttribute, (CharSequence)this.name());
        tag.put(ATTRIBUTE_NAME_CONTENT, (CharSequence)this.content());
    }

    public static enum Type {
        Detect(""),
        Default("name"),
        HttpEquiv("http-equiv"),
        Property("property");

        private final String nameAttribute;

        private Type(String nameAttribute) {
            this.nameAttribute = nameAttribute;
        }

        public String toString() {
            return this.nameAttribute;
        }
    }
}

