/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class URLEncodeFunction
implements Function {
    private static final Log log = LogFactory.getLog(URLEncodeFunction.class);

    public Object call(Context context, List args) throws FunctionCallException {
        boolean debugOn = log.isDebugEnabled();
        if (args == null || args.size() == 0) {
            if (debugOn) {
                log.debug((Object)"Property key value for lookup is not specified");
            }
            return "";
        }
        int size = args.size();
        if (size == 1) {
            String value = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            return this.encode(debugOn, "UTF-8", value);
        }
        if (size == 2) {
            String value = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String encoding = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            return this.encode(debugOn, encoding, value);
        }
        if (debugOn) {
            log.debug((Object)"url-encode function expects only one argument, returning empty string");
        }
        return "";
    }

    private Object encode(boolean debugOn, String encoding, String value) throws FunctionCallException {
        String encodedString;
        if (value == null || "".equals(value)) {
            if (debugOn) {
                log.debug((Object)"Non empty string value should be provided for encoding");
            }
            return "";
        }
        try {
            encodedString = URIUtil.encodePathQuery((String)value, (String)encoding);
        }
        catch (URIException e) {
            String msg = "Unsupported charset encoding";
            log.error((Object)msg, (Throwable)e);
            throw new FunctionCallException(msg, (Exception)((Object)e));
        }
        if (debugOn) {
            log.debug((Object)("Converted string: " + value + " with encoding: " + encoding + " to url encoded value: " + encodedString));
        }
        return encodedString;
    }
}

