/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.metrics.flink;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.CheckPointType;

public class CheckPoints
implements Serializable {
    private List<CheckPoint> history;
    private Latest latest;

    @JsonIgnore
    public List<CheckPoint> getLatestCheckpoint() {
        if (this.latest == null) {
            return Collections.emptyList();
        }
        return this.latest.getLatestCheckpoint();
    }

    public List<CheckPoint> getHistory() {
        return this.history;
    }

    public Latest getLatest() {
        return this.latest;
    }

    public void setHistory(List<CheckPoint> history) {
        this.history = history;
    }

    public void setLatest(Latest latest) {
        this.latest = latest;
    }

    public static class Latest
    implements Serializable {
        private CheckPoint completed;
        private CheckPoint savepoint;
        private CheckPoint failed;

        @JsonIgnore
        public List<CheckPoint> getLatestCheckpoint() {
            ArrayList<CheckPoint> checkPoints = new ArrayList<CheckPoint>();
            if (this.completed != null) {
                checkPoints.add(this.completed);
            }
            if (this.savepoint != null) {
                checkPoints.add(this.savepoint);
            }
            if (this.failed != null) {
                if (this.completed == null) {
                    checkPoints.add(this.failed);
                } else if (this.failed.getId() > this.completed.getId()) {
                    checkPoints.add(this.failed);
                }
            }
            return checkPoints;
        }

        public CheckPoint getCompleted() {
            return this.completed;
        }

        public CheckPoint getSavepoint() {
            return this.savepoint;
        }

        public CheckPoint getFailed() {
            return this.failed;
        }

        public void setCompleted(CheckPoint completed) {
            this.completed = completed;
        }

        public void setSavepoint(CheckPoint savepoint) {
            this.savepoint = savepoint;
        }

        public void setFailed(CheckPoint failed) {
            this.failed = failed;
        }
    }

    public static class CheckPoint
    implements Serializable {
        private Long id;
        private String status;
        @JsonProperty(value="external_path")
        private String externalPath;
        @JsonProperty(value="is_savepoint")
        private Boolean isSavepoint;
        @JsonProperty(value="latest_ack_timestamp")
        private Long latestAckTimestamp;
        @JsonProperty(value="checkpoint_type")
        private String checkpointType;
        @JsonProperty(value="trigger_timestamp")
        private Long triggerTimestamp;
        @JsonProperty(value="state_size")
        private Long stateSize;
        @JsonProperty(value="end_to_end_duration")
        private Long endToEndDuration;
        private Boolean discarded;

        public CheckPointStatus getCheckPointStatus() {
            return CheckPointStatus.valueOf(this.status);
        }

        public CheckPointType getCheckPointType() {
            if ("CHECKPOINT".equals(this.checkpointType)) {
                return CheckPointType.CHECKPOINT;
            }
            if ("SAVEPOINT".equals(this.checkpointType)) {
                return CheckPointType.SAVEPOINT;
            }
            return CheckPointType.SYNC_SAVEPOINT;
        }

        public String getPath() {
            return this.getExternalPath().replaceFirst("^hdfs:/[^/]", "hdfs:///");
        }

        public Long getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public String getExternalPath() {
            return this.externalPath;
        }

        public Boolean getIsSavepoint() {
            return this.isSavepoint;
        }

        public Long getLatestAckTimestamp() {
            return this.latestAckTimestamp;
        }

        public Long getTriggerTimestamp() {
            return this.triggerTimestamp;
        }

        public Long getStateSize() {
            return this.stateSize;
        }

        public Long getEndToEndDuration() {
            return this.endToEndDuration;
        }

        public Boolean getDiscarded() {
            return this.discarded;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="external_path")
        public void setExternalPath(String externalPath) {
            this.externalPath = externalPath;
        }

        @JsonProperty(value="is_savepoint")
        public void setIsSavepoint(Boolean isSavepoint) {
            this.isSavepoint = isSavepoint;
        }

        @JsonProperty(value="latest_ack_timestamp")
        public void setLatestAckTimestamp(Long latestAckTimestamp) {
            this.latestAckTimestamp = latestAckTimestamp;
        }

        @JsonProperty(value="checkpoint_type")
        public void setCheckpointType(String checkpointType) {
            this.checkpointType = checkpointType;
        }

        @JsonProperty(value="trigger_timestamp")
        public void setTriggerTimestamp(Long triggerTimestamp) {
            this.triggerTimestamp = triggerTimestamp;
        }

        @JsonProperty(value="state_size")
        public void setStateSize(Long stateSize) {
            this.stateSize = stateSize;
        }

        @JsonProperty(value="end_to_end_duration")
        public void setEndToEndDuration(Long endToEndDuration) {
            this.endToEndDuration = endToEndDuration;
        }

        public void setDiscarded(Boolean discarded) {
            this.discarded = discarded;
        }
    }
}

