/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.ByteComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class BytePrimitiveArrayComparator
extends PrimitiveArrayComparator<byte[], ByteComparator> {
    public BytePrimitiveArrayComparator(boolean ascending) {
        super(ascending, new ByteComparator(ascending));
    }

    @Override
    public int hash(byte[] record) {
        int result = 0;
        for (byte field : record) {
            result += field;
        }
        return result;
    }

    @Override
    public int compare(byte[] first, byte[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp = first[x] - second[x];
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<byte[]> duplicate() {
        BytePrimitiveArrayComparator dupe = new BytePrimitiveArrayComparator(this.ascending);
        dupe.setReference(this.reference);
        return dupe;
    }
}

