/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProgramOptionsUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ProgramOptionsUtils.class);

    public static boolean isPythonEntryPoint(CommandLine line) {
        return line.hasOption(CliFrontendParser.PY_OPTION.getOpt()) || line.hasOption(CliFrontendParser.PYMODULE_OPTION.getOpt()) || "org.apache.flink.client.python.PythonGatewayServer".equals(line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()));
    }

    public static boolean containsPythonDependencyOptions(CommandLine line) {
        return line.hasOption(CliFrontendParser.PYFILES_OPTION.getOpt()) || line.hasOption(CliFrontendParser.PYREQUIREMENTS_OPTION.getOpt()) || line.hasOption(CliFrontendParser.PYARCHIVE_OPTION.getOpt()) || line.hasOption(CliFrontendParser.PYEXEC_OPTION.getOpt()) || line.hasOption(CliFrontendParser.PYCLIENTEXEC_OPTION.getOpt());
    }

    public static ProgramOptions createPythonProgramOptions(CommandLine line) throws CliArgsException {
        try {
            ClassLoader classLoader = ProgramOptionsUtils.getPythonClassLoader();
            Class<?> pythonProgramOptionsClazz = Class.forName("org.apache.flink.client.cli.PythonProgramOptions", false, classLoader);
            Constructor<?> constructor = pythonProgramOptionsClazz.getConstructor(CommandLine.class);
            return (ProgramOptions)constructor.newInstance(line);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CliArgsException("Python command line option detected but the flink-python module seems to be missing or not working as expected.", e);
        }
    }

    private static ClassLoader getPythonClassLoader() {
        try {
            return new URLClassLoader(new URL[]{PackagedProgramUtils.getPythonJar()}, Thread.currentThread().getContextClassLoader());
        }
        catch (RuntimeException e) {
            LOG.warn("An attempt to load the flink-python jar from the \"opt\" directory failed, fall back to use the context class loader.", (Throwable)e);
            return Thread.currentThread().getContextClassLoader();
        }
    }

    public static void configurePythonExecution(Configuration configuration, PackagedProgram packagedProgram) throws Exception {
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        CommandLine commandLine = CliFrontendParser.parse(commandOptions, packagedProgram.getArguments(), true);
        ProgramOptions programOptions = ProgramOptionsUtils.createPythonProgramOptions(commandLine);
        String[] programArgs = programOptions.extractProgramArgs(commandLine);
        Field argsField = packagedProgram.getClass().getDeclaredField("args");
        argsField.setAccessible(true);
        argsField.set(packagedProgram, programArgs);
        Field pythonConfiguration = programOptions.getClass().getDeclaredField("pythonConfiguration");
        pythonConfiguration.setAccessible(true);
        ClassLoader classLoader = ProgramOptionsUtils.getPythonClassLoader();
        Class<?> pythonDependencyUtilsClazz = Class.forName("org.apache.flink.python.util.PythonDependencyUtils", false, classLoader);
        Method mergeMethod = pythonDependencyUtilsClazz.getDeclaredMethod("merge", Configuration.class, Configuration.class);
        mergeMethod.invoke(null, configuration, pythonConfiguration.get(programOptions));
    }
}

