/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV2V3SerializerBase;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.util.Preconditions;

@Internal
public class MetadataV2Serializer
extends MetadataV2V3SerializerBase
implements MetadataSerializer {
    public static final int VERSION = 2;
    public static final MetadataV2Serializer INSTANCE = new MetadataV2Serializer();

    private MetadataV2Serializer() {
    }

    public int getVersion() {
        return 2;
    }

    @Override
    public CheckpointMetadata deserialize(DataInputStream dis, ClassLoader classLoader, String externalPointer) throws IOException {
        return this.deserializeMetadata(dis, externalPointer);
    }

    @Override
    protected void serializeOperatorState(OperatorState operatorState, DataOutputStream dos) throws IOException {
        Preconditions.checkState((!operatorState.isFullyFinished() ? 1 : 0) != 0, (Object)"Could not support finished Operator state in state serializers.");
        dos.writeLong(operatorState.getOperatorID().getLowerPart());
        dos.writeLong(operatorState.getOperatorID().getUpperPart());
        int parallelism = operatorState.getParallelism();
        dos.writeInt(parallelism);
        dos.writeInt(operatorState.getMaxParallelism());
        dos.writeInt(1);
        Map<Integer, OperatorSubtaskState> subtaskStateMap = operatorState.getSubtaskStates();
        dos.writeInt(subtaskStateMap.size());
        for (Map.Entry<Integer, OperatorSubtaskState> entry : subtaskStateMap.entrySet()) {
            dos.writeInt(entry.getKey());
            this.serializeSubtaskState(entry.getValue(), dos);
        }
    }

    @Override
    protected OperatorState deserializeOperatorState(DataInputStream dis, @Nullable MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        OperatorID jobVertexId = new OperatorID(dis.readLong(), dis.readLong());
        int parallelism = dis.readInt();
        int maxParallelism = dis.readInt();
        dis.readInt();
        OperatorState taskState = new OperatorState(jobVertexId, parallelism, maxParallelism);
        int numSubTaskStates = dis.readInt();
        for (int j = 0; j < numSubTaskStates; ++j) {
            int subtaskIndex = dis.readInt();
            OperatorSubtaskState subtaskState = this.deserializeSubtaskState(dis, context);
            taskState.putState(subtaskIndex, subtaskState);
        }
        return taskState;
    }

    @Override
    protected void serializeSubtaskState(OperatorSubtaskState subtaskState, DataOutputStream dos) throws IOException {
        dos.writeLong(-1L);
        dos.writeInt(0);
        super.serializeSubtaskState(subtaskState, dos);
    }

    @Override
    protected OperatorSubtaskState deserializeSubtaskState(DataInputStream dis, @Nullable MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        dis.readLong();
        int numLegacyTaskStates = dis.readInt();
        if (numLegacyTaskStates > 0) {
            throw new IOException("Legacy state (from Flink <= 1.1, created through the 'Checkpointed' interface) is no longer supported.");
        }
        return super.deserializeSubtaskState(dis, context);
    }
}

