/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.HadoopUtils$;
import org.apache.streampark.common.util.HttpClientUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.YarnUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

public final class YarnUtils$
implements Logger {
    public static final YarnUtils$ MODULE$;
    public String org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
    private String PROXY_YARN_URL;
    private boolean hasYarnHttpKerberosAuth;
    private boolean hasYarnHttpSampleAuth;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new YarnUtils$();
    }

    private String PROXY_YARN_URL$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PROXY_YARN_URL = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_PROXY_YARN_URL());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.PROXY_YARN_URL;
        }
    }

    private boolean hasYarnHttpKerberosAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpKerberosAuth = "kerberos".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.hasYarnHttpKerberosAuth;
        }
    }

    private boolean hasYarnHttpSampleAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpSampleAuth = "sample".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.hasYarnHttpSampleAuth;
        }
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    public String PROXY_YARN_URL() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PROXY_YARN_URL$lzycompute() : this.PROXY_YARN_URL;
    }

    public boolean hasYarnHttpKerberosAuth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hasYarnHttpKerberosAuth$lzycompute() : this.hasYarnHttpKerberosAuth;
    }

    public boolean hasYarnHttpSampleAuth() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.hasYarnHttpSampleAuth$lzycompute() : this.hasYarnHttpSampleAuth;
    }

    public List<ApplicationId> getAppId(String appName) {
        Buffer buffer;
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.RUNNING, YarnApplicationState.ACCEPTED, YarnApplicationState.SUBMITTED);
        try {
            buffer = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(HadoopUtils$.MODULE$.yarnClient().getApplications(appStates)).filter((Function1)new Serializable(appName){
                public static final long serialVersionUID = 0L;
                private final String appName$1;

                public final boolean apply(ApplicationReport x$1) {
                    String string = x$1.getName();
                    String string2 = this.appName$1;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.appName$1 = appName$1;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ApplicationId apply(ApplicationReport x$2) {
                    return x$2.getApplicationId();
                }
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            buffer = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
        Buffer appIds = buffer;
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)appIds.toList());
    }

    /*
     * WARNING - void declaration
     */
    public YarnApplicationState getState(String appId) {
        void var3_5;
        YarnApplicationState yarnApplicationState;
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appId);
        try {
            ApplicationReport applicationReport = HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId);
            yarnApplicationState = applicationReport.getYarnApplicationState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            yarnApplicationState = null;
        }
        YarnApplicationState state = yarnApplicationState;
        return var3_5;
    }

    public boolean isContains(String appName) {
        List runningApps = HadoopUtils$.MODULE$.yarnClient().getApplications(EnumSet.of(YarnApplicationState.RUNNING));
        return runningApps == null ? false : JavaConversions$.MODULE$.asScalaBuffer(runningApps).exists((Function1)new Serializable(appName){
            public static final long serialVersionUID = 0L;
            private final String appName$2;

            public final boolean apply(ApplicationReport x$3) {
                String string = x$3.getName();
                String string2 = this.appName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.appName$2 = appName$2;
            }
        });
    }

    public String getRMWebAppProxyURL() {
        return StringUtils.isNotBlank((CharSequence)this.PROXY_YARN_URL()) ? this.PROXY_YARN_URL() : this.getRMWebAppURL(this.getRMWebAppURL$default$1());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRMWebAppURL(boolean getLatest) {
        BoxedUnit boxedUnit;
        if (this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL != null && !getLatest) {
            boxedUnit = BoxedUnit.UNIT;
            return this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
        }
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            String string;
            Tuple3 tuple32;
            boolean useHttps;
            Configuration conf = HadoopUtils$.MODULE$.hadoopConf();
            boolean bl = useHttps = YarnConfiguration.useHttps((Configuration)conf);
            Tuple3 tuple33 = bl ? new Tuple3((Object)"yarn.resourcemanager.webapp.https.address", (Object)"8090", (Object)"https://") : new Tuple3((Object)"yarn.resourcemanager.webapp.address", (Object)"8088", (Object)"http://");
            Tuple3 tuple3 = tuple33;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            String addressPrefix = (String)tuple3._1();
            String defaultPort = (String)tuple3._2();
            String protocol = (String)tuple3._3();
            Tuple3 tuple34 = tuple32 = new Tuple3((Object)addressPrefix, (Object)defaultPort, (Object)protocol);
            String addressPrefix2 = (String)tuple34._1();
            String defaultPort2 = (String)tuple34._2();
            String protocol2 = (String)tuple34._3();
            Option option = Option$.MODULE$.apply((Object)conf.get("yarn.web-proxy.address", null));
            if (option instanceof Some) {
                Some some = (Some)option;
                String proxy = (String)some.x();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol2, proxy}));
            } else {
                StringBuilder stringBuilder;
                String string2;
                if (HAUtil.isHAEnabled((Configuration)conf)) {
                    String string3;
                    YarnConfiguration yarnConf = new YarnConfiguration(conf);
                    Option option2 = Option$.MODULE$.apply((Object)RMHAUtils.findActiveRMHAId((Configuration)yarnConf));
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String x = (String)some.x();
                        this.logInfo((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "findActiveRMHAId successful";
                            }
                        });
                        string3 = x;
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                        this.logWarn((Function0<String>)new Serializable(yarnConf){
                            public static final long serialVersionUID = 0L;
                            private final YarnConfiguration yarnConf$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"findActiveRMHAId is null,config yarn.acl.enable:", ",now http try it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.yarnConf$1.get("yarn.acl.enable")}));
                            }
                            {
                                this.yarnConf$1 = yarnConf$1;
                            }
                        });
                        HashMap idUrlMap = new HashMap();
                        Collection rmIds = HAUtil.getRMHAIds((Configuration)conf);
                        JavaConversions$.MODULE$.collectionAsScalaIterable(rmIds).foreach((Function1)new Serializable(conf, addressPrefix2, defaultPort2, protocol2, idUrlMap){
                            public static final long serialVersionUID = 0L;
                            private final Configuration conf$1;
                            private final String addressPrefix$1;
                            private final String defaultPort$1;
                            private final String protocol$1;
                            private final HashMap idUrlMap$1;

                            public final String apply(String id) {
                                String string;
                                String string2 = this.conf$1.get(HAUtil.addSuffix((String)this.addressPrefix$1, (String)id));
                                if (string2 == null) {
                                    String hostname = this.conf$1.get(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)id));
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostname, this.defaultPort$1}));
                                } else {
                                    string = string2;
                                }
                                String address = string;
                                return this.idUrlMap$1.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocol$1, address})), id);
                            }
                            {
                                this.conf$1 = conf$1;
                                this.addressPrefix$1 = addressPrefix$1;
                                this.defaultPort$1 = defaultPort$1;
                                this.protocol$1 = protocol$1;
                                this.idUrlMap$1 = idUrlMap$1;
                            }
                        });
                        ObjectRef rmId = ObjectRef.create(null);
                        int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
                        Breaks$.MODULE$.breakable((Function0)new Serializable(idUrlMap, rmId, rpcTimeoutForChecks){
                            public static final long serialVersionUID = 0L;
                            public final HashMap idUrlMap$1;
                            public final ObjectRef rmId$1;
                            public final int rpcTimeoutForChecks$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                JavaConversions$.MODULE$.mapAsScalaMap((Map)this.idUrlMap$1).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.1 $outer;

                                    public final void apply(Tuple2<String, String> x) {
                                        String activeUrl = YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$httpTestYarnRMUrl((String)x._1(), this.$outer.rpcTimeoutForChecks$1);
                                        if (activeUrl == null) {
                                            return;
                                        }
                                        this.$outer.rmId$1.elem = (String)JavaConversions$.MODULE$.mapAsScalaMap((Map)this.$outer.idUrlMap$1).apply((Object)activeUrl);
                                        throw Breaks$.MODULE$.break();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.idUrlMap$1 = idUrlMap$1;
                                this.rmId$1 = rmId$1;
                                this.rpcTimeoutForChecks$1 = rpcTimeoutForChecks$1;
                            }
                        });
                        string3 = (String)rmId.elem;
                    }
                    String activeRMId = string3;
                    Predef$.MODULE$.require(activeRMId != null, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "[StreamPark] YarnUtils.getRMWebAppURL: can not found yarn active node";
                        }
                    });
                    this.logInfo((Function0<String>)new Serializable(activeRMId){
                        public static final long serialVersionUID = 0L;
                        private final String activeRMId$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current activeRMHAId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.activeRMId$1}));
                        }
                        {
                            this.activeRMId$1 = activeRMId$1;
                        }
                    });
                    String appActiveRMKey = HAUtil.addSuffix((String)addressPrefix2, (String)activeRMId);
                    String hostnameActiveRMKey = HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)activeRMId);
                    if (HAUtil.getConfValueForRMInstance((String)appActiveRMKey, (Configuration)yarnConf) == null && HAUtil.getConfValueForRMInstance((String)hostnameActiveRMKey, (Configuration)yarnConf) != null) {
                        this.logInfo((Function0<String>)new Serializable(hostnameActiveRMKey){
                            public static final long serialVersionUID = 0L;
                            private final String hostnameActiveRMKey$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find rm web address by : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostnameActiveRMKey$1}));
                            }
                            {
                                this.hostnameActiveRMKey$1 = hostnameActiveRMKey$1;
                            }
                        });
                        string2 = hostnameActiveRMKey;
                    } else {
                        this.logInfo((Function0<String>)new Serializable(appActiveRMKey){
                            public static final long serialVersionUID = 0L;
                            private final String appActiveRMKey$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Find rm web address by : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appActiveRMKey$1}));
                            }
                            {
                                this.appActiveRMKey$1 = appActiveRMKey$1;
                            }
                        });
                        string2 = appActiveRMKey;
                    }
                } else {
                    string2 = addressPrefix2;
                }
                String name = string2;
                InetSocketAddress inetSocketAddress = conf.getSocketAddr(name, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.0.0.0:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultPort2})), new StringOps(Predef$.MODULE$.augmentString(defaultPort2)).toInt());
                InetSocketAddress address = NetUtils.getConnectAddress((InetSocketAddress)inetSocketAddress);
                StringBuilder buffer = new StringBuilder(protocol2);
                InetAddress resolved = address.getAddress();
                if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
                    StringBuilder stringBuilder2;
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return InetAddress.getLocalHost().getCanonicalHostName();
                        }
                    });
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        String value = (String)success.value();
                        stringBuilder2 = buffer.append(value);
                    } else {
                        stringBuilder2 = buffer.append(address.getHostName());
                    }
                    stringBuilder = stringBuilder2;
                } else {
                    stringBuilder = buffer.append(address.getHostName());
                }
                string = buffer.append(":").append(address.getPort()).toString();
            }
            this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL = string;
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarn resourceManager webapp url:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{YarnUtils$.MODULE$.org$apache$streampark$common$util$YarnUtils$$rmHttpURL}));
                }
            });
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl76 : MonitorExitStatement: MONITOREXIT : yarnUtils$
            boxedUnit = boxedUnit2;
            return this.org$apache$streampark$common$util$YarnUtils$$rmHttpURL;
        }
    }

    public boolean getRMWebAppURL$default$1() {
        return false;
    }

    public String org$apache$streampark$common$util$YarnUtils$$httpTestYarnRMUrl(String url, int timeout) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        httpGet.setConfig(requestConfig);
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(httpClient, context, httpGet){
            public static final long serialVersionUID = 0L;
            private final CloseableHttpClient httpClient$1;
            private final HttpClientContext context$1;
            private final HttpGet httpGet$1;

            public final CloseableHttpResponse apply() {
                return this.httpClient$1.execute((HttpUriRequest)this.httpGet$1, this.context$1);
            }
            {
                this.httpClient$1 = httpClient$1;
                this.context$1 = context$1;
                this.httpGet$1 = httpGet$1;
            }
        });
        String string = try_ instanceof Success ? context.getTargetHost().toString() : null;
        return string;
    }

    public String getYarnAppTrackingUrl(ApplicationId applicationId) {
        return HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId).getTrackingUrl();
    }

    public String restRequest(String url) {
        String resp;
        if (url == null) {
            return null;
        }
        String string = url;
        String string2 = string.matches("^http(|s)://.*") ? this.request$1(url) : ((resp = this.request$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getRMWebAppURL(this.getRMWebAppURL$default$1()), url})))) == null ? this.request$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getRMWebAppURL(true), url}))) : resp);
        return string2;
    }

    private final String request$1(String reqUrl) {
        Try try_;
        block6: {
            String string;
            block3: {
                String string2;
                block5: {
                    block4: {
                        String v;
                        RequestConfig config;
                        block2: {
                            this.logDebug((Function0<String>)new Serializable(reqUrl){
                                public static final long serialVersionUID = 0L;
                                private final String reqUrl$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"request url is ").append((Object)this.reqUrl$1).toString();
                                }
                                {
                                    this.reqUrl$1 = reqUrl$1;
                                }
                            });
                            config = RequestConfig.custom().setConnectTimeout(5000).build();
                            if (!this.hasYarnHttpKerberosAuth()) break block2;
                            string = (String)HadoopUtils$.MODULE$.getUgi().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(reqUrl, config){
                                public final String reqUrl$1;
                                public final RequestConfig config$1;

                                public String run() {
                                    Try try_;
                                    block4: {
                                        String string;
                                        block3: {
                                            block2: {
                                                String v;
                                                try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anon.1 $outer;

                                                    public final String apply() {
                                                        return HttpClientUtils$.MODULE$.httpAuthGetRequest(this.$outer.reqUrl$1, this.$outer.config$1);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                });
                                                if (!(try_ instanceof Success)) break block2;
                                                Success success = (Success)try_;
                                                string = v = (String)success.value();
                                                break block3;
                                            }
                                            if (!(try_ instanceof Failure)) break block4;
                                            Failure failure = (Failure)try_;
                                            Throwable e = failure.exception();
                                            YarnUtils$.MODULE$.logError((Function0<String>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return "yarnUtils authRestRequest error, detail: ";
                                                }
                                            }, e);
                                            string = null;
                                        }
                                        return string;
                                    }
                                    throw new MatchError((Object)try_);
                                }
                                {
                                    this.reqUrl$1 = reqUrl$1;
                                    this.config$1 = config$1;
                                }
                            });
                            break block3;
                        }
                        String url = this.hasYarnHttpSampleAuth() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?user.name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reqUrl, HadoopUtils$.MODULE$.hadoopUserName()})) : reqUrl;
                        try_ = Try$.MODULE$.apply((Function0)new Serializable(config, url){
                            public static final long serialVersionUID = 0L;
                            private final RequestConfig config$1;
                            private final String url$1;

                            public final String apply() {
                                return HttpClientUtils$.MODULE$.httpGetRequest(this.url$1, this.config$1);
                            }
                            {
                                this.config$1 = config$1;
                                this.url$1 = url$1;
                            }
                        });
                        if (!(try_ instanceof Success)) break block4;
                        Success success = (Success)try_;
                        string2 = v = (String)success.value();
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break block6;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "yarnUtils restRequest error, detail: ";
                        }
                    }, e);
                    string2 = null;
                }
                string = string2;
            }
            return string;
        }
        throw new MatchError((Object)try_);
    }

    private YarnUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

