/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.apache.flink.util.Preconditions;

@Internal
public class ConnectionLimitingFactory
implements FileSystemFactory {
    private final FileSystemFactory factory;
    private final LimitedConnectionsFileSystem.ConnectionLimitingSettings settings;

    private ConnectionLimitingFactory(FileSystemFactory factory, LimitedConnectionsFileSystem.ConnectionLimitingSettings settings) {
        this.factory = Preconditions.checkNotNull(factory);
        this.settings = Preconditions.checkNotNull(settings);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.factory.getClassLoader();
    }

    @Override
    public String getScheme() {
        return this.factory.getScheme();
    }

    @Override
    public void configure(Configuration config) {
        this.factory.configure(config);
    }

    @Override
    public FileSystem create(URI fsUri) throws IOException {
        FileSystem original = this.factory.create(fsUri);
        return new LimitedConnectionsFileSystem(original, this.settings.limitTotal, this.settings.limitOutput, this.settings.limitInput, this.settings.streamOpenTimeout, this.settings.streamInactivityTimeout);
    }

    public static FileSystemFactory decorateIfLimited(FileSystemFactory factory, String scheme, Configuration config) {
        Preconditions.checkNotNull(factory, "factory");
        LimitedConnectionsFileSystem.ConnectionLimitingSettings settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig(config, scheme);
        if (settings == null) {
            return factory;
        }
        return new ConnectionLimitingFactory(factory, settings);
    }
}

