/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.feature.extension.apiregions.api.DeprecationInfo;

public class Deprecation {
    private DeprecationInfo packageInfo;
    private final Map<String, DeprecationInfo> memberInfos = new LinkedHashMap<String, DeprecationInfo>();

    public DeprecationInfo getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(DeprecationInfo i) {
        if (!this.memberInfos.isEmpty()) {
            throw new IllegalStateException("Member is already deprecated");
        }
        this.packageInfo = i;
    }

    public void addMemberInfo(String member, DeprecationInfo i) {
        if (this.packageInfo != null) {
            throw new IllegalStateException("Package is already deprecated");
        }
        this.memberInfos.put(member, i);
    }

    public void removeMemberInfo(String member) {
        this.memberInfos.remove(member);
    }

    public Map<String, DeprecationInfo> getMemberInfos() {
        return this.memberInfos;
    }

    public static final String getClassName(String member) {
        int pos = member.indexOf("#");
        if (pos == -1) {
            return member;
        }
        return member.substring(0, pos);
    }

    public static final String getClassMemberName(String member) {
        int pos = member.indexOf("#");
        if (pos == -1) {
            return null;
        }
        return member.substring(pos + 1);
    }

    public int hashCode() {
        return Objects.hash(this.memberInfos, this.packageInfo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Deprecation other = (Deprecation)obj;
        return Objects.equals(this.memberInfos, other.memberInfos) && Objects.equals(this.packageInfo, other.packageInfo);
    }
}

