/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.binary.jcr;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(PackageCleaner.class);
    private ResourceResolver resolver;
    private long deleteOlderThanTime;

    public PackageCleaner(ResourceResolver resolver, long deleteOlderThanTime) {
        this.resolver = resolver;
        this.deleteOlderThanTime = deleteOlderThanTime;
    }

    public int cleanup(Resource root) throws PersistenceException {
        int removedCount = 0;
        for (Resource pkgNode : root.getChildren()) {
            removedCount += this.cleanNode(pkgNode);
        }
        if (this.resolver.hasChanges()) {
            this.resolver.commit();
        }
        return removedCount;
    }

    private int cleanNode(Resource pkgNode) throws PersistenceException {
        long createdTime = (Long)pkgNode.getValueMap().get("jcr:created", Long.class);
        if (createdTime < this.deleteOlderThanTime) {
            LOG.info("removing package={}, created={} < deleteTime={}", new Object[]{pkgNode.getName(), createdTime, this.deleteOlderThanTime});
            this.resolver.delete(pkgNode);
            return 1;
        }
        return 0;
    }
}

