/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc.classloader;

import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.classloader.DynamicClassLoaderProvider;
import org.apache.sling.maven.jspc.classloader.ClassLoaderFacade;
import org.apache.sling.maven.jspc.classloader.DynamicClassLoaderManagerFactory;
import org.apache.sling.maven.jspc.classloader.PackageAdminClassLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClassLoaderManagerImpl
implements DynamicClassLoaderManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader[] loaders;
    private final ClassLoaderFacade facade;
    private volatile boolean active = true;
    private final ServiceTracker deprecatedProviderTracker;

    public DynamicClassLoaderManagerImpl(final BundleContext ctx, PackageAdmin pckAdmin, ClassLoader parent, DynamicClassLoaderManagerFactory factory) {
        this.deprecatedProviderTracker = new ServiceTracker(ctx, DynamicClassLoaderProvider.class.getName(), new ServiceTrackerCustomizer(){

            public void removedService(ServiceReference serviceRef, Object paramObject) {
                ctx.ungetService(serviceRef);
            }

            public void modifiedService(ServiceReference serviceRef, Object paramObject) {
            }

            public Object addingService(ServiceReference serviceRef) {
                Object obj = ctx.getService(serviceRef);
                if (obj != null) {
                    DynamicClassLoaderManagerImpl.this.logger.warn("Dynamic class loader does not support deprecated dynamic class loader providers: {} : {}", (Object)serviceRef, obj);
                }
                return obj;
            }
        });
        this.deprecatedProviderTracker.open();
        this.loaders = new ClassLoader[]{new PackageAdminClassLoader(pckAdmin, parent, factory)};
        this.facade = new ClassLoaderFacade(this);
    }

    public void deactivate() {
        this.deprecatedProviderTracker.close();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public ClassLoader getDynamicClassLoader() {
        return this.facade;
    }

    public ClassLoader[] getDynamicClassLoaders() {
        return this.loaders;
    }
}

