/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.nacos.v2;

import com.alibaba.nacos.api.config.remote.request.ConfigChangeNotifyRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.remote.request.InstanceRequest;
import com.alibaba.nacos.api.naming.remote.request.NotifySubscriberRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceListRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceQueryRequest;
import com.alibaba.nacos.api.naming.remote.request.SubscribeServiceRequest;
import com.alibaba.nacos.api.remote.request.Request;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.nacos.v2.constant.NacosConstants;

public class NacosRequestOpt {
    private static final Map<Class, Handler> OPTS = new HashMap<Class, Handler>();

    private static AbstractSpan getNacosEntrySpan(String peer) {
        AbstractSpan span = ContextManager.createEntrySpan((String)"Nacos/", null);
        span.setComponent((Component)ComponentsDefine.NACOS);
        span.setPeer(peer);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        return span;
    }

    private static AbstractSpan getNacosExitSpan(String peer) {
        AbstractSpan span = ContextManager.createExitSpan((String)"Nacos/", (String)peer);
        span.setComponent((Component)ComponentsDefine.NACOS);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        return span;
    }

    public static Optional<Handler> getHandler(Class clazz) {
        return Optional.ofNullable(OPTS.get(clazz));
    }

    static {
        OPTS.put(InstanceRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + ((InstanceRequest)request).getType());
            span.tag(NacosConstants.NAME_SPACE_TAG, ((InstanceRequest)request).getNamespace());
            span.tag(NacosConstants.GROUP_TAG, ((InstanceRequest)request).getGroupName());
            span.tag(NacosConstants.SERVICE_NAME_TAG, ((InstanceRequest)request).getServiceName());
        });
        OPTS.put(ServiceQueryRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + "queryService");
            span.tag(NacosConstants.NAME_SPACE_TAG, ((ServiceQueryRequest)request).getNamespace());
            span.tag(NacosConstants.GROUP_TAG, ((ServiceQueryRequest)request).getGroupName());
            span.tag(NacosConstants.SERVICE_NAME_TAG, ((ServiceQueryRequest)request).getServiceName());
        });
        OPTS.put(SubscribeServiceRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + (((SubscribeServiceRequest)request).isSubscribe() ? "subscribeService" : "unsubscribeService"));
            span.tag(NacosConstants.NAME_SPACE_TAG, ((SubscribeServiceRequest)request).getNamespace());
            span.tag(NacosConstants.GROUP_TAG, ((SubscribeServiceRequest)request).getGroupName());
            span.tag(NacosConstants.SERVICE_NAME_TAG, ((SubscribeServiceRequest)request).getServiceName());
        });
        OPTS.put(ServiceListRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + "getServiceList");
            span.tag(NacosConstants.NAME_SPACE_TAG, ((ServiceListRequest)request).getNamespace());
            span.tag(NacosConstants.GROUP_TAG, ((ServiceListRequest)request).getGroupName());
            span.tag(NacosConstants.SERVICE_NAME_TAG, ((ServiceListRequest)request).getServiceName());
        });
        OPTS.put(ConfigQueryRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + "queryConfig");
            span.tag(NacosConstants.DATA_ID_TAG, ((ConfigQueryRequest)request).getDataId());
            span.tag(NacosConstants.GROUP_TAG, ((ConfigQueryRequest)request).getGroup());
            span.tag(NacosConstants.TENANT_TAG, ((ConfigQueryRequest)request).getTenant());
        });
        OPTS.put(ConfigPublishRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + "publishConfig");
            span.tag(NacosConstants.DATA_ID_TAG, ((ConfigPublishRequest)request).getDataId());
            span.tag(NacosConstants.GROUP_TAG, ((ConfigPublishRequest)request).getGroup());
            span.tag(NacosConstants.TENANT_TAG, ((ConfigPublishRequest)request).getTenant());
        });
        OPTS.put(ConfigRemoveRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosExitSpan(peer);
            span.setOperationName(span.getOperationName() + "removeConfig");
            span.tag(NacosConstants.DATA_ID_TAG, ((ConfigRemoveRequest)request).getDataId());
            span.tag(NacosConstants.GROUP_TAG, ((ConfigRemoveRequest)request).getGroup());
            span.tag(NacosConstants.TENANT_TAG, ((ConfigRemoveRequest)request).getTenant());
        });
        OPTS.put(NotifySubscriberRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosEntrySpan(peer);
            span.setOperationName(span.getOperationName() + "notifySubscribeChange");
            ServiceInfo serviceInfo = ((NotifySubscriberRequest)request).getServiceInfo();
            span.tag(NacosConstants.GROUP_TAG, serviceInfo.getGroupName());
            span.tag(NacosConstants.SERVICE_NAME_TAG, serviceInfo.getName());
        });
        OPTS.put(ConfigChangeNotifyRequest.class, (request, peer) -> {
            AbstractSpan span = NacosRequestOpt.getNacosEntrySpan(peer);
            span.setOperationName(span.getOperationName() + "notifyConfigChange");
            span.tag(NacosConstants.DATA_ID_TAG, ((ConfigChangeNotifyRequest)request).getDataId());
            span.tag(NacosConstants.GROUP_TAG, ((ConfigChangeNotifyRequest)request).getGroup());
            span.tag(NacosConstants.TENANT_TAG, ((ConfigChangeNotifyRequest)request).getTenant());
        });
    }

    static interface Handler {
        public void buildRequestSpanInfo(Request var1, String var2);
    }
}

