/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.websocket;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

@UnstableApi
public final class WebSocketCloseStatus {
    public static final WebSocketCloseStatus NORMAL_CLOSURE = new WebSocketCloseStatus(1000, "Bye");
    public static final WebSocketCloseStatus ENDPOINT_UNAVAILABLE = new WebSocketCloseStatus(1001, "Endpoint unavailable");
    public static final WebSocketCloseStatus PROTOCOL_ERROR = new WebSocketCloseStatus(1002, "Protocol error");
    public static final WebSocketCloseStatus INVALID_MESSAGE_TYPE = new WebSocketCloseStatus(1003, "Invalid message type");
    public static final WebSocketCloseStatus INVALID_PAYLOAD_DATA = new WebSocketCloseStatus(1007, "Invalid payload data");
    public static final WebSocketCloseStatus POLICY_VIOLATION = new WebSocketCloseStatus(1008, "Policy violation");
    public static final WebSocketCloseStatus MESSAGE_TOO_BIG = new WebSocketCloseStatus(1009, "Message too big");
    public static final WebSocketCloseStatus MANDATORY_EXTENSION = new WebSocketCloseStatus(1010, "Mandatory extension");
    public static final WebSocketCloseStatus INTERNAL_SERVER_ERROR = new WebSocketCloseStatus(1011, "Internal server error");
    public static final WebSocketCloseStatus SERVICE_RESTART = new WebSocketCloseStatus(1012, "Service Restart");
    public static final WebSocketCloseStatus TRY_AGAIN_LATER = new WebSocketCloseStatus(1013, "Try Again Later");
    public static final WebSocketCloseStatus BAD_GATEWAY = new WebSocketCloseStatus(1014, "Bad Gateway");
    public static final WebSocketCloseStatus EMPTY = new WebSocketCloseStatus(1005, "Empty");
    public static final WebSocketCloseStatus ABNORMAL_CLOSURE = new WebSocketCloseStatus(1006, "Abnormal closure");
    public static final WebSocketCloseStatus TLS_HANDSHAKE_FAILED = new WebSocketCloseStatus(1015, "TLS handshake failed");
    private final int statusCode;
    private final String reasonPhrase;
    @Nullable
    private String text;

    public static WebSocketCloseStatus ofPrivateUse(int code, String reasonPhrase) {
        Preconditions.checkArgument(code >= 4000 && code < 5000, "code: %s (expected: 4000 <= code < 5000)", code);
        Preconditions.checkArgument(reasonPhrase.getBytes().length <= 125, "reasonPhrase: %s (expected: <= 125 bytes)", (Object)reasonPhrase);
        return new WebSocketCloseStatus(code, Objects.requireNonNull(reasonPhrase, "reasonPhrase"));
    }

    public static boolean isValidStatusCode(int code) {
        return 1000 <= code && code <= 1003 || 1007 <= code && code <= 1014 || 3000 <= code;
    }

    public static WebSocketCloseStatus valueOf(int code) {
        switch (code) {
            case 1000: {
                return NORMAL_CLOSURE;
            }
            case 1001: {
                return ENDPOINT_UNAVAILABLE;
            }
            case 1002: {
                return PROTOCOL_ERROR;
            }
            case 1003: {
                return INVALID_MESSAGE_TYPE;
            }
            case 1005: {
                return EMPTY;
            }
            case 1006: {
                return ABNORMAL_CLOSURE;
            }
            case 1007: {
                return INVALID_PAYLOAD_DATA;
            }
            case 1008: {
                return POLICY_VIOLATION;
            }
            case 1009: {
                return MESSAGE_TOO_BIG;
            }
            case 1010: {
                return MANDATORY_EXTENSION;
            }
            case 1011: {
                return INTERNAL_SERVER_ERROR;
            }
            case 1012: {
                return SERVICE_RESTART;
            }
            case 1013: {
                return TRY_AGAIN_LATER;
            }
            case 1014: {
                return BAD_GATEWAY;
            }
            case 1015: {
                return TLS_HANDSHAKE_FAILED;
            }
        }
        if (!WebSocketCloseStatus.isValidStatusCode(code)) {
            throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC 6455: " + code);
        }
        return new WebSocketCloseStatus(code, "Close status #" + code);
    }

    private WebSocketCloseStatus(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public int code() {
        return this.statusCode;
    }

    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WebSocketCloseStatus)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        WebSocketCloseStatus that = (WebSocketCloseStatus)o;
        return this.statusCode == that.statusCode;
    }

    public int hashCode() {
        return this.statusCode;
    }

    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.code() + " " + this.reasonPhrase();
        return this.text;
    }
}

