/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.ArrayList;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public interface JavaMailSender
extends MailSender {
    public MimeMessage createMimeMessage();

    public MimeMessage createMimeMessage(InputStream var1) throws MailException;

    default public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage ... var1) throws MailException;

    default public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    default public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(mimeMessagePreparators.length);
            for (MimeMessagePreparator preparator : mimeMessagePreparators) {
                MimeMessage mimeMessage = this.createMimeMessage();
                preparator.prepare(mimeMessage);
                mimeMessages.add(mimeMessage);
            }
            this.send(mimeMessages.toArray(new MimeMessage[0]));
        }
        catch (MailException ex) {
            throw ex;
        }
        catch (MessagingException ex) {
            throw new MailParseException(ex);
        }
        catch (Exception ex) {
            throw new MailPreparationException(ex);
        }
    }
}

