/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.sofa;

import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.sofa.SofaPlugin;
import org.apache.shenyu.plugin.sofa.context.SofaShenyuContextDecorator;
import org.apache.shenyu.plugin.sofa.handler.SofaMetaDataHandler;
import org.apache.shenyu.plugin.sofa.handler.SofaPluginDataHandler;
import org.apache.shenyu.plugin.sofa.param.SofaParamResolveService;
import org.apache.shenyu.plugin.sofa.param.SofaParamResolveServiceImpl;
import org.apache.shenyu.plugin.sofa.proxy.SofaProxyService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SofaPlugin.class})
@ConditionalOnProperty(value={"shenyu.plugins.sofa.enabled"}, havingValue="true", matchIfMissing=true)
public class SofaPluginConfiguration {
    @Bean
    public ShenyuPlugin sofaPlugin(ObjectProvider<SofaParamResolveService> sofaParamResolveService) {
        return new SofaPlugin(new SofaProxyService((SofaParamResolveService)sofaParamResolveService.getIfAvailable()));
    }

    @Bean
    @ConditionalOnMissingBean(value={SofaParamResolveService.class}, search=SearchStrategy.ALL)
    public SofaParamResolveService sofaParamResolveService() {
        return new SofaParamResolveServiceImpl();
    }

    @Bean
    public PluginDataHandler sofaPluginDataHandler() {
        return new SofaPluginDataHandler();
    }

    @Bean
    public MetaDataHandler sofaMetaDataHandler() {
        return new SofaMetaDataHandler();
    }

    @Bean
    public ShenyuContextDecorator sofaShenyuContextDecorator() {
        return new SofaShenyuContextDecorator();
    }
}

