/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer.scala;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.util.GraalvmSupport;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import java.lang.reflect.Field;

public class SingletonObjectSerializer
extends Serializer {
    private final Field field;
    private long offset = -1L;

    public SingletonObjectSerializer(Fury fury, Class type) {
        super(fury, type);
        try {
            this.field = type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(type + " doesn't have `MODULE$` field", e);
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
    }

    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
        }
        return Platform.getObject(this.type, offset);
    }
}

