/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.IoBuffer;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.WorkThread;
import com.qq.tars.net.protocol.ProtocolEncoder;
import com.qq.tars.net.protocol.ProtocolException;
import com.qq.tars.net.protocol.ProtocolFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;

public class UDPSession
extends Session {
    private int bufferSize = 4096;
    private SelectorManager selectorManager = null;
    private SelectableChannel channel = null;
    private SocketAddress target = null;

    public UDPSession(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    public void setBufferSize(int size) {
        if (size <= 0 || size > 65536) {
            return;
        }
        this.bufferSize = size;
    }

    @Override
    public void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    @Override
    protected void accept() throws IOException {
        throw new IllegalStateException("Can't handle accept method.");
    }

    @Override
    public void asyncClose() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getRemoteIp() {
        if (this.target != null) {
            return ((InetSocketAddress)this.target).getAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this.channel != null) {
            return ((InetSocketAddress)this.target).getPort();
        }
        return 0;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.selectorManager.getProtocolFactory();
    }

    public final void setTarget(SocketAddress address) {
        if (address != null) {
            this.target = address;
        }
    }

    @Override
    protected void read() throws IOException {
        ByteBuffer buffer = this.doRead();
        this.selectorManager.getThreadPool().execute(new WorkThread(this, buffer, this.selectorManager));
    }

    @Override
    public void write(Request request) throws IOException {
        try {
            ProtocolFactory factory = this.selectorManager.getProtocolFactory();
            ProtocolEncoder encoder = factory.getEncoder();
            IoBuffer buffer = encoder.encodeRequest(request, this);
            int size = ((DatagramChannel)this.channel).send(buffer.buf(), this.target);
            if (size <= 0) {
                throw new IOException("failed to send data. {target=" + this.target + "}");
            }
        }
        catch (ProtocolException ex) {
            throw new IOException("protocol error:", ex);
        }
    }

    @Override
    public void write(Response response) throws IOException {
        try {
            IoBuffer buffer = this.selectorManager.getProtocolFactory().getEncoder().encodeResponse(response, this);
            int size = ((DatagramChannel)this.channel).send(buffer.buf(), this.target);
            if (size <= 0) {
                throw new IOException("failed to send data. {target=" + this.target + "}");
            }
        }
        catch (ProtocolException ex) {
            throw new IOException("protocol error:", ex);
        }
    }

    public ByteBuffer doRead() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(this.bufferSize);
        SocketAddress address = ((DatagramChannel)this.channel).receive(data);
        data.flip();
        if (data.remaining() >= this.bufferSize) {
            throw new IOException("package size CAN NOT >= " + this.bufferSize);
        }
        if (this.target == null) {
            this.setTarget(address);
        }
        return data;
    }

    Object parseDatagramPacket(ByteBuffer data) throws IOException {
        try {
            if (this.status == Session.SessionStatus.CLIENT_CONNECTED) {
                return this.readResponse(data);
            }
            if (this.status == Session.SessionStatus.SERVER_CONNECTED) {
                return this.readRequest(data);
            }
            throw new IllegalStateException("The current session status is invalid. [status:" + (Object)((Object)this.status) + "]");
        }
        catch (ProtocolException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Response readResponse(ByteBuffer data) throws IOException, ProtocolException {
        Response response = this.selectorManager.getProtocolFactory().getDecoder().decodeResponse(IoBuffer.wrap(data), this);
        if (response != null && response.getTicketNumber() == -1) {
            response.setTicketNumber(response.getSession().hashCode());
        }
        return response;
    }

    private Request readRequest(ByteBuffer data) throws IOException, ProtocolException {
        Request request = this.selectorManager.getProtocolFactory().getDecoder().decodeRequest(IoBuffer.wrap(data), this);
        if (request == null) {
            throw new ProtocolException("failed to decode udp packet.");
        }
        request.resetBornTime();
        return request;
    }
}

