/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CrossFilter
implements WebFilter {
    private static final String ALL = "*";
    private final ShenyuConfig.CrossFilterConfig filterConfig;

    public CrossFilter(ShenyuConfig.CrossFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (CorsUtils.isCorsRequest((ServerHttpRequest)request)) {
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = response.getHeaders();
            String origin = request.getHeaders().getOrigin();
            boolean allowCors = this.filterConfig.isAllowedAnyOrigin();
            if (!allowCors && Objects.nonNull(this.filterConfig.getAllowedOrigin())) {
                String originRegex;
                String scheme = exchange.getRequest().getURI().getScheme();
                ShenyuConfig.CrossFilterConfig.AllowedOriginConfig allowedOriginConfig = this.filterConfig.getAllowedOrigin();
                Set allowedOrigin = Optional.ofNullable(allowedOriginConfig.getPrefixes()).orElse(Collections.emptySet()).stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(prefix -> String.format("%s://%s%s%s", scheme, prefix.trim(), StringUtils.defaultString((String)allowedOriginConfig.getSpacer(), (String)".").trim(), StringUtils.defaultString((String)allowedOriginConfig.getDomain(), (String)"").trim())).collect(Collectors.toSet());
                allowedOrigin.addAll(Optional.ofNullable(allowedOriginConfig.getOrigins()).orElse(Collections.emptySet()).stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(oneOrigin -> {
                    if (ALL.equals(oneOrigin) || oneOrigin.startsWith(String.format("%s://", scheme))) {
                        return oneOrigin.trim();
                    }
                    return String.format("%s://%s", scheme, oneOrigin.trim());
                }).collect(Collectors.toSet()));
                boolean bl = allowCors = allowedOrigin.contains(origin) || allowedOrigin.contains(ALL);
                if (!allowCors && StringUtils.isNotBlank((CharSequence)(originRegex = this.filterConfig.getAllowedOrigin().getOriginRegex()))) {
                    allowCors = Pattern.matches(originRegex.trim(), origin);
                }
            }
            if (allowCors) {
                headers.set("Access-Control-Allow-Origin", origin);
                this.filterSameHeader(headers, "Access-Control-Allow-Methods", this.filterConfig.getAllowedMethods());
                this.filterSameHeader(headers, "Access-Control-Max-Age", this.filterConfig.getMaxAge());
                this.filterSameHeader(headers, "Access-Control-Allow-Headers", this.filterConfig.getAllowedHeaders());
                this.filterSameHeader(headers, "Access-Control-Expose-Headers", this.filterConfig.getAllowedExpose());
                this.filterSameHeader(headers, "Access-Control-Allow-Credentials", String.valueOf(this.filterConfig.isAllowCredentials()));
            }
            if (request.getMethod() == HttpMethod.OPTIONS) {
                response.setStatusCode((HttpStatusCode)HttpStatus.OK);
                return Mono.empty();
            }
        }
        return chain.filter(exchange);
    }

    private void filterSameHeader(HttpHeaders headers, String header, String newHeaderValue) {
        if (StringUtils.isBlank((CharSequence)newHeaderValue)) {
            return;
        }
        if (ALL.equals(newHeaderValue.trim())) {
            headers.set(header, ALL);
            return;
        }
        Set newHeaders = Stream.of(newHeaderValue.split(",")).map(String::trim).collect(Collectors.toSet());
        List originHeaders = headers.get((Object)header);
        if (CollectionUtils.isNotEmpty((Collection)originHeaders)) {
            if (originHeaders.contains(ALL)) {
                return;
            }
            originHeaders = Stream.of(String.join((CharSequence)",", originHeaders).split(",")).map(String::trim).collect(Collectors.toList());
            newHeaders.addAll(originHeaders);
        }
        headers.set(header, String.join((CharSequence)",", newHeaders));
    }
}

