/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.get_script_context;

import co.elastic.clients.elasticsearch.core.get_script_context.ContextMethodParam;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ContextMethod
implements JsonpSerializable {
    private final String name;
    private final String returnType;
    private final List<ContextMethodParam> params;
    public static final JsonpDeserializer<ContextMethod> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ContextMethod::setupContextMethodDeserializer);

    private ContextMethod(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.returnType = ApiTypeHelper.requireNonNull(builder.returnType, this, "returnType");
        this.params = ApiTypeHelper.unmodifiableRequired(builder.params, (Object)this, "params");
    }

    public static ContextMethod of(Function<Builder, ObjectBuilder<ContextMethod>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String returnType() {
        return this.returnType;
    }

    public final List<ContextMethodParam> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("return_type");
        generator.write(this.returnType);
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartArray();
            for (ContextMethodParam item0 : this.params) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupContextMethodDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::returnType, JsonpDeserializer.stringDeserializer(), "return_type");
        op.add(Builder::params, JsonpDeserializer.arrayDeserializer(ContextMethodParam._DESERIALIZER), "params");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ContextMethod> {
        private String name;
        private String returnType;
        private List<ContextMethodParam> params;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder returnType(String value) {
            this.returnType = value;
            return this;
        }

        public final Builder params(List<ContextMethodParam> list) {
            this.params = Builder._listAddAll(this.params, list);
            return this;
        }

        public final Builder params(ContextMethodParam value, ContextMethodParam ... values) {
            this.params = Builder._listAdd(this.params, value, values);
            return this;
        }

        public final Builder params(Function<ContextMethodParam.Builder, ObjectBuilder<ContextMethodParam>> fn) {
            return this.params(fn.apply(new ContextMethodParam.Builder()).build(), new ContextMethodParam[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ContextMethod build() {
            this._checkSingleUse();
            return new ContextMethod(this);
        }
    }
}

