/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class RedisPersistentProperty
extends KeyValuePersistentProperty<RedisPersistentProperty> {
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();

    public RedisPersistentProperty(Property property, PersistentEntity<?, RedisPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getName());
    }

    static {
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
    }
}

