/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Objects;

public class RateLimiterHandle {
    private String algorithmName;
    private double replenishRate;
    private double burstCapacity;
    private double requestCount = 1.0;
    private boolean loged;
    private String keyResolverName;

    public static RateLimiterHandle newDefaultInstance() {
        RateLimiterHandle rateLimiterHandle = new RateLimiterHandle();
        rateLimiterHandle.setAlgorithmName("tokenBucket");
        rateLimiterHandle.setReplenishRate(1.0);
        rateLimiterHandle.setBurstCapacity(100.0);
        rateLimiterHandle.setRequestCount(1.0);
        rateLimiterHandle.setLoged(false);
        return rateLimiterHandle;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public double getReplenishRate() {
        return this.replenishRate;
    }

    public void setReplenishRate(double replenishRate) {
        this.replenishRate = replenishRate;
    }

    public double getBurstCapacity() {
        return this.burstCapacity;
    }

    public void setBurstCapacity(double burstCapacity) {
        this.burstCapacity = burstCapacity;
    }

    public double getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(double requestCount) {
        this.requestCount = requestCount;
    }

    public boolean isLoged() {
        return this.loged;
    }

    public void setLoged(boolean loged) {
        this.loged = loged;
    }

    public String getKeyResolverName() {
        return this.keyResolverName;
    }

    public void setKeyResolverName(String keyResolverName) {
        this.keyResolverName = keyResolverName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimiterHandle that = (RateLimiterHandle)o;
        return Double.compare(that.replenishRate, this.replenishRate) == 0 && Double.compare(that.burstCapacity, this.burstCapacity) == 0 && Double.compare(that.requestCount, this.requestCount) == 0 && this.loged == that.loged && Objects.equals(this.algorithmName, that.algorithmName) && Objects.equals(this.keyResolverName, that.keyResolverName);
    }

    public int hashCode() {
        return Objects.hash(this.algorithmName, this.replenishRate, this.burstCapacity, this.requestCount, this.loged, this.keyResolverName);
    }

    public String toString() {
        return "RateLimiterHandle{algorithmName='" + this.algorithmName + "', replenishRate=" + this.replenishRate + ", burstCapacity=" + this.burstCapacity + ", requestCount=" + this.requestCount + ", loged=" + this.loged + ", keyResolverName='" + this.keyResolverName + "'}";
    }
}

