/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.DigestUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboMethodParam;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboParam;
import org.apache.shenyu.plugin.dubbo.common.handler.AbstractDubboPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheDubboConfigCache
extends DubboConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDubboConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ConsumerConfig consumerConfig;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (Objects.nonNull(config)) {
            config.destroy();
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        @Nonnull
        public ReferenceConfig<GenericService> load(@Nonnull String key) {
            return new ReferenceConfig();
        }
    });

    public static ApacheDubboConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.applicationConfig)) {
            this.applicationConfig = new ApplicationConfig("shenyu_proxy");
            this.applicationConfig.setQosEnable(Boolean.valueOf(false));
            this.applicationConfig.setRegisterConsumer(Boolean.valueOf(true));
        }
        if (this.needUpdateRegistryConfig(dubboRegisterConfig)) {
            RegistryConfig registryConfigTemp = new RegistryConfig();
            registryConfigTemp.setProtocol(dubboRegisterConfig.getProtocol());
            registryConfigTemp.setId("shenyu_proxy");
            registryConfigTemp.setRegister(Boolean.valueOf(false));
            registryConfigTemp.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
            this.registryConfig = registryConfigTemp;
        }
        if (Objects.isNull(this.consumerConfig)) {
            this.consumerConfig = new ConsumerConfig();
            this.consumerConfig.refresh();
            Optional.ofNullable(dubboRegisterConfig.getThreadpool()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreadpool(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getCorethreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setCorethreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getThreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getQueues()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setQueues(arg_0));
        }
    }

    private boolean needUpdateRegistryConfig(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.registryConfig)) {
            return true;
        }
        return !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol()) || !Objects.equals(dubboRegisterConfig.getRegister(), this.registryConfig.getAddress());
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData, "");
    }

    public ReferenceConfig<GenericService> initRefN(MetaData metaData, String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            return this.initRef(metaData);
        }
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)(namespace + ":" + metaData.getPath()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("initRefN dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData, namespace);
    }

    public ReferenceConfig<GenericService> initRefN(String selectorId, RuleData ruleData, MetaData metaData, String namespace, DubboUpstream dubboUpstream) {
        try {
            String cacheKey = this.generateUpstreamCacheKey(selectorId, ruleData.getId(), metaData.getId(), namespace, dubboUpstream);
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)cacheKey);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("initRefN dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData, ruleData, namespace, selectorId, dubboUpstream);
    }

    public String generateUpstreamCacheKey(String selectorId, String ruleId, String metaDataId, String namespace, DubboUpstream dubboUpstream) {
        StringJoiner stringJoiner = new StringJoiner("_");
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            stringJoiner.add(namespace);
        }
        stringJoiner.add(selectorId);
        stringJoiner.add(ruleId);
        stringJoiner.add(metaDataId);
        if (StringUtils.isNotBlank((CharSequence)dubboUpstream.getProtocol())) {
            stringJoiner.add(dubboUpstream.getProtocol());
        }
        String registryHash = DigestUtils.md5Hex((String)dubboUpstream.getRegistry());
        stringJoiner.add(registryHash);
        if (StringUtils.isNotBlank((CharSequence)dubboUpstream.getVersion())) {
            stringJoiner.add(dubboUpstream.getVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)dubboUpstream.getGroup())) {
            stringJoiner.add(dubboUpstream.getGroup());
        }
        return stringJoiner.toString();
    }

    public ReferenceConfig<GenericService> build(MetaData metaData, String namespace) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ReferenceConfig();
        }
        ReferenceConfig<GenericService> reference = this.buildReference(metaData, namespace);
        try {
            Object obj = reference.get();
            if (Objects.nonNull(obj)) {
                LOG.info("buildN init apache dubbo reference success there meteData is :{}", (Object)metaData);
                this.cache.put(StringUtils.isNotBlank((CharSequence)namespace) ? namespace + ":" + metaData.getPath() : metaData.getPath(), reference);
            }
        }
        catch (Exception e) {
            LOG.error("buildN init apache dubbo reference exception", (Throwable)e);
        }
        return reference;
    }

    public ReferenceConfig<GenericService> build(MetaData metaData, RuleData ruleData, String namespace, String selectorId, DubboUpstream dubboUpstream) {
        if (Objects.isNull(dubboUpstream)) {
            return this.build(metaData, namespace);
        }
        ReferenceConfig<GenericService> reference = this.buildReference(metaData, ruleData, namespace, dubboUpstream);
        try {
            Object obj = reference.get();
            if (Objects.nonNull(obj)) {
                LOG.info("buildN init apache dubbo reference success there meteData is :{}", (Object)metaData);
                String cacheKey = this.generateUpstreamCacheKey(selectorId, ruleData.getId(), metaData.getId(), namespace, dubboUpstream);
                this.cache.put((Object)cacheKey, reference);
            }
        }
        catch (Exception e) {
            LOG.error("buildN init apache dubbo reference exception", (Throwable)e);
        }
        return reference;
    }

    private ReferenceConfig<GenericService> buildReference(MetaData metaData, String namespace) {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.setAsync(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setConsumer(this.consumerConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setCheck(Boolean.valueOf(false));
        reference.setLoadbalance("gray");
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("dispatcher", "direct");
        reference.setParameters(parameters);
        String rpcExt = metaData.getRpcExt();
        DubboParam dubboParam = this.parserToDubboParam(rpcExt);
        if (Objects.nonNull(dubboParam)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getVersion()})) {
                reference.setVersion(dubboParam.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getGroup()})) {
                reference.setGroup(dubboParam.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getUrl()})) {
                reference.setUrl(dubboParam.getUrl());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getCluster()})) {
                reference.setCluster(dubboParam.getCluster());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getLoadbalance()})) {
                reference.getParameters().put("dubboLoadBalance", dubboParam.getLoadbalance());
            }
            if ("protobuf".equals(dubboParam.getSerialization())) {
                reference.setGeneric("protobuf-json");
            }
            Optional.ofNullable(dubboParam.getProtocol()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setProtocol(arg_0));
            Optional.ofNullable(dubboParam.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParam.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
            Optional.ofNullable(dubboParam.getSent()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setSent(arg_0));
            if (CollectionUtils.isNotEmpty((Collection)dubboParam.getMethods())) {
                reference.setMethods(new ArrayList());
                for (DubboMethodParam dubboMethodParam : dubboParam.getMethods()) {
                    MethodConfig methodConfig = new MethodConfig();
                    methodConfig.setName(dubboMethodParam.getName());
                    methodConfig.setLoadbalance("gray");
                    methodConfig.setRetries(dubboMethodParam.getRetries());
                    methodConfig.setTimeout(dubboMethodParam.getTimeout());
                    methodConfig.setSent(dubboMethodParam.getSent());
                    HashMap<String, String> methodsParameters = new HashMap<String, String>(1);
                    methodsParameters.put("dubboLoadBalance", dubboMethodParam.getLoadbalance());
                    methodConfig.setParameters(methodsParameters);
                    reference.getMethods().add(methodConfig);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            this.changeRegistryAddressNamespace(this.registryConfig, (ReferenceConfig<GenericService>)reference, namespace);
        }
        return reference;
    }

    private ReferenceConfig<GenericService> buildReference(MetaData metaData, RuleData ruleData, String namespace, DubboUpstream dubboUpstream) {
        if (Objects.isNull(dubboUpstream)) {
            return this.buildReference(metaData, namespace);
        }
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.setAsync(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        RegistryConfig registryConfigTemp = new RegistryConfig();
        registryConfigTemp.setProtocol(dubboUpstream.getProtocol());
        registryConfigTemp.setId("shenyu_proxy");
        registryConfigTemp.setRegister(Boolean.valueOf(false));
        registryConfigTemp.setAddress(dubboUpstream.getRegistry());
        Optional.ofNullable(dubboUpstream.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
        Optional.ofNullable(dubboUpstream.getVersion()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setVersion(arg_0));
        reference.setRegistry(registryConfigTemp);
        DubboRuleHandle dubboRuleHandle = (DubboRuleHandle)((CommonHandleCache)AbstractDubboPluginDataHandler.RULE_CACHED_HANDLE.get()).obtainHandle((Object)ruleData.getId());
        ConsumerConfig consumerConfigTmp = new ConsumerConfig();
        if (ObjectUtils.isNotEmpty((Object)dubboRuleHandle)) {
            consumerConfigTmp.refresh();
            Optional.ofNullable(this.consumerConfig.getThreadpool()).ifPresent(arg_0 -> ((ConsumerConfig)consumerConfigTmp).setThreadpool(arg_0));
            Optional.ofNullable(this.consumerConfig.getCorethreads()).ifPresent(arg_0 -> ((ConsumerConfig)consumerConfigTmp).setCorethreads(arg_0));
            Optional.ofNullable(this.consumerConfig.getThreads()).ifPresent(arg_0 -> ((ConsumerConfig)consumerConfigTmp).setThreads(arg_0));
            Optional.ofNullable(this.consumerConfig.getQueues()).ifPresent(arg_0 -> ((ConsumerConfig)consumerConfigTmp).setQueues(arg_0));
            consumerConfigTmp.setRetries(dubboRuleHandle.getRetries());
            consumerConfigTmp.setTimeout(Integer.valueOf((int)dubboRuleHandle.getTimeout()));
        }
        reference.setConsumer(consumerConfigTmp);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setCheck(Boolean.valueOf(false));
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("dispatcher", "direct");
        reference.setParameters(parameters);
        this.configReferenceConfigWithMetaDataRpcExt(metaData.getRpcExt(), (ReferenceConfig<GenericService>)reference);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            this.changeRegistryAddressNamespace(registryConfigTemp, (ReferenceConfig<GenericService>)reference, namespace);
        }
        return reference;
    }

    private void changeRegistryAddressNamespace(RegistryConfig currentRegistryConfig, ReferenceConfig<GenericService> reference, String namespace) {
        RegistryConfig registryConfigNew = new RegistryConfig();
        registryConfigNew.setRegister(Boolean.valueOf(false));
        if (!currentRegistryConfig.getAddress().contains("namespace")) {
            registryConfigNew.setAddress(currentRegistryConfig.getAddress() + "?namespace=" + namespace);
        } else {
            String newAddress = currentRegistryConfig.getAddress().substring(0, currentRegistryConfig.getAddress().indexOf("namespace") + 1) + "namespace=" + namespace;
            registryConfigNew.setAddress(newAddress);
        }
        reference.setRegistry(registryConfigNew);
    }

    private void configReferenceConfigWithMetaDataRpcExt(String rpcExt, ReferenceConfig<GenericService> reference) {
        DubboParam dubboParam = this.parserToDubboParam(rpcExt);
        if (Objects.isNull(dubboParam)) {
            return;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getVersion()})) {
            reference.setVersion(dubboParam.getVersion());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getGroup()})) {
            reference.setGroup(dubboParam.getGroup());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getUrl()})) {
            reference.setUrl(dubboParam.getUrl());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getCluster()})) {
            reference.setCluster(dubboParam.getCluster());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getLoadbalance()})) {
            reference.getParameters().put("dubboLoadBalance", dubboParam.getLoadbalance());
        }
        if ("protobuf".equals(dubboParam.getSerialization())) {
            reference.setGeneric("protobuf-json");
        }
        Optional.ofNullable(dubboParam.getProtocol()).ifPresent(arg_0 -> reference.setProtocol(arg_0));
        Optional.ofNullable(dubboParam.getTimeout()).ifPresent(arg_0 -> reference.setTimeout(arg_0));
        Optional.ofNullable(dubboParam.getRetries()).ifPresent(arg_0 -> reference.setRetries(arg_0));
        Optional.ofNullable(dubboParam.getSent()).ifPresent(arg_0 -> reference.setSent(arg_0));
        if (CollectionUtils.isNotEmpty((Collection)dubboParam.getMethods())) {
            reference.setMethods(new ArrayList());
            for (DubboMethodParam dubboMethodParam : dubboParam.getMethods()) {
                MethodConfig methodConfig = new MethodConfig();
                methodConfig.setName(dubboMethodParam.getName());
                methodConfig.setRetries(dubboMethodParam.getRetries());
                methodConfig.setTimeout(dubboMethodParam.getTimeout());
                methodConfig.setSent(dubboMethodParam.getSent());
                HashMap<String, String> methodsParameters = new HashMap<String, String>(1);
                methodsParameters.put("dubboLoadBalance", dubboMethodParam.getLoadbalance());
                methodConfig.setParameters(methodsParameters);
                reference.getMethods().add(methodConfig);
            }
        }
    }

    public ReferenceConfig<GenericService> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void invalidateWithSelectorId(String selectorId) {
        ConcurrentMap map = this.cache.asMap();
        Set allKeys = map.keySet();
        Set<String> needInvalidateKeys = allKeys.stream().filter(key -> key.contains(selectorId)).collect(Collectors.toSet());
        needInvalidateKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public void invalidateWithRuleId(String ruleId) {
        ConcurrentMap map = this.cache.asMap();
        Set allKeys = map.keySet();
        Set<String> needInvalidateKeys = allKeys.stream().filter(key -> key.contains(ruleId)).collect(Collectors.toSet());
        needInvalidateKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public void invalidateWithMetadataId(String metadataId) {
        ConcurrentMap map = this.cache.asMap();
        Set allKeys = map.keySet();
        Set<String> needInvalidateKeys = allKeys.stream().filter(key -> key.contains(metadataId)).collect(Collectors.toSet());
        needInvalidateKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    static final class ApplicationConfigCacheInstance {
        static final ApacheDubboConfigCache INSTANCE = new ApacheDubboConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

