/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.throwable;

import com.caucho.hessian.io.AbstractFieldAdaptorSerializer;
import com.caucho.hessian.io.AbstractHessianOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackTraceElementSerializer
extends AbstractFieldAdaptorSerializer {
    protected static final Logger log = Logger.getLogger(StackTraceElementSerializer.class.getName());
    private final Class<StackTraceElement> _clazz = StackTraceElement.class;
    private static final String GET_PREFIX = "get";
    private Map<String, Method> _readMethods = new HashMap<String, Method>();

    public StackTraceElementSerializer() {
        super(StackTraceElement.class);
        for (Field field : this._fields) {
            String fieldName = field.getName();
            String methodName = GET_PREFIX + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if ("declaringClass".equals(fieldName)) {
                methodName = "getClassName";
            }
            try {
                Method m = this._clazz.getMethod(methodName, new Class[0]);
                this._readMethods.put(fieldName, m);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.WARNING, "getter not found: " + methodName, e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    @Override
    protected void serializeField(AbstractHessianOutput out, Object obj, Field field) throws IOException {
        if (!this._readMethods.containsKey(field.getName())) {
            out.writeNull();
            return;
        }
        if (String.class.equals(field.getType())) {
            String value = null;
            try {
                value = (String)this._readMethods.get(field.getName()).invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            out.writeString(value);
        } else if (Integer.TYPE.equals(field.getType())) {
            Integer value = 0;
            try {
                value = (Integer)this._readMethods.get(field.getName()).invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            out.writeInt(value);
        } else {
            log.warning("unsupported field " + field.getName() + "(" + field.getType() + "), will write null");
            out.writeNull();
        }
    }

    @Override
    protected Field[] getFieldsForSerialize(Class cl) {
        ArrayList<Field> primitiveFields = new ArrayList<Field>();
        ArrayList<Field> compoundFields = new ArrayList<Field>();
        while (cl != null) {
            Field[] originFields = cl.getDeclaredFields();
            for (int i = 0; i < originFields.length; ++i) {
                Field field = originFields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "format".equals(field.getName())) continue;
                if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.lang.") && !field.getType().equals(Object.class)) {
                    primitiveFields.add(field);
                    continue;
                }
                compoundFields.add(field);
            }
            cl = cl.getSuperclass();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(primitiveFields);
        fields.addAll(compoundFields);
        return fields.toArray(new Field[0]);
    }
}

