/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tcp.handler;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.plugin.tcp.handler.TcpBootstrapFactory;
import org.apache.shenyu.protocol.tcp.BootstrapServer;
import org.apache.shenyu.protocol.tcp.UpstreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpUpstreamDataHandler
implements DiscoveryUpstreamDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TcpUpstreamDataHandler.class);

    public String pluginName() {
        return PluginEnum.TCP.getName();
    }

    public void handlerDiscoveryUpstreamData(DiscoverySyncData discoverySyncData) {
        List removed = UpstreamProvider.getSingleton().refreshCache(discoverySyncData.getSelectorName(), discoverySyncData.getUpstreamDataList());
        BootstrapServer bootstrapServer = TcpBootstrapFactory.getSingleton().getCache(discoverySyncData.getSelectorName());
        if (Objects.nonNull(bootstrapServer)) {
            bootstrapServer.removeCommonUpstream(removed);
            LOG.info("shenyu update TcpBootstrapServer [{}] success upstream is {}", (Object)discoverySyncData.getSelectorName(), (Object)discoverySyncData.getUpstreamDataList());
        } else {
            LOG.warn("shenyu update TcpBootstrapServer don't find name is {}", (Object)discoverySyncData.getSelectorName());
        }
    }
}

