/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TriplePingPongHandler
extends ChannelDuplexHandler {
    private final long pingAckTimeout;
    private ScheduledFuture<?> pingAckTimeoutFuture;

    public TriplePingPongHandler(long pingAckTimeout) {
        this.pingAckTimeout = pingAckTimeout;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2PingFrame) || this.pingAckTimeoutFuture == null) {
            super.channelRead(ctx, msg);
            return;
        }
        this.pingAckTimeoutFuture.cancel(true);
        this.pingAckTimeoutFuture = null;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt instanceof IdleStateEvent)) {
            ctx.fireUserEventTriggered(evt);
            return;
        }
        ctx.writeAndFlush((Object)new DefaultHttp2PingFrame(0L));
        if (this.pingAckTimeoutFuture == null) {
            this.pingAckTimeoutFuture = ctx.executor().schedule((Runnable)new CloseChannelTask(ctx), this.pingAckTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private static class CloseChannelTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        public CloseChannelTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (this.ctx.channel().isActive()) {
                this.ctx.close();
            }
        }
    }
}

