/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public abstract class AbstractServiceDiscoveryFactory
implements ServiceDiscoveryFactory,
ScopeModelAware {
    protected ApplicationModel applicationModel;
    private final ConcurrentMap<String, ServiceDiscovery> discoveries = new ConcurrentHashMap<String, ServiceDiscovery>();

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public List<ServiceDiscovery> getAllServiceDiscoveries() {
        return Collections.unmodifiableList(new LinkedList(this.discoveries.values()));
    }

    @Override
    public ServiceDiscovery getServiceDiscovery(URL registryURL) {
        String key = this.createRegistryCacheKey(registryURL);
        return ConcurrentHashMapUtils.computeIfAbsent(this.discoveries, key, k -> this.createDiscovery(registryURL));
    }

    protected String createRegistryCacheKey(URL url) {
        return url.toServiceStringWithoutResolving();
    }

    protected abstract ServiceDiscovery createDiscovery(URL var1);
}

