/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceStatComposite
extends AbstractMetricsExport {
    private final AtomicBoolean samplesChanged = new AtomicBoolean(true);
    private final Map<MetricsKeyWrapper, Map<ServiceKeyMetric, AtomicLong>> serviceWrapperNumStats = new ConcurrentHashMap<MetricsKeyWrapper, Map<ServiceKeyMetric, AtomicLong>>();

    public ServiceStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public void initWrapper(List<MetricsKeyWrapper> metricsKeyWrappers) {
        if (CollectionUtils.isEmpty(metricsKeyWrappers)) {
            return;
        }
        metricsKeyWrappers.forEach(appKey -> this.serviceWrapperNumStats.put((MetricsKeyWrapper)appKey, new ConcurrentHashMap()));
        this.samplesChanged.set(true);
    }

    public void incrementServiceKey(MetricsKeyWrapper wrapper, String serviceKey, int size) {
        this.incrementExtraServiceKey(wrapper, serviceKey, null, size);
    }

    public void incrementExtraServiceKey(MetricsKeyWrapper wrapper, String serviceKey, Map<String, String> extra, int size) {
        Map<ServiceKeyMetric, AtomicLong> map;
        AtomicLong metrics;
        if (!this.serviceWrapperNumStats.containsKey(wrapper)) {
            return;
        }
        ServiceKeyMetric serviceKeyMetric = new ServiceKeyMetric(this.getApplicationModel(), serviceKey);
        if (extra != null) {
            serviceKeyMetric.setExtraInfo(extra);
        }
        if ((metrics = (map = this.serviceWrapperNumStats.get(wrapper)).get(serviceKeyMetric)) == null) {
            metrics = map.computeIfAbsent(serviceKeyMetric, k -> new AtomicLong(0L));
            this.samplesChanged.set(true);
        }
        metrics.getAndAdd(size);
    }

    public void setServiceKey(MetricsKeyWrapper wrapper, String serviceKey, int num) {
        this.setExtraServiceKey(wrapper, serviceKey, num, null);
    }

    public void setExtraServiceKey(MetricsKeyWrapper wrapper, String serviceKey, int num, Map<String, String> extra) {
        Map<ServiceKeyMetric, AtomicLong> stats;
        AtomicLong metrics;
        if (!this.serviceWrapperNumStats.containsKey(wrapper)) {
            return;
        }
        ServiceKeyMetric serviceKeyMetric = new ServiceKeyMetric(this.getApplicationModel(), serviceKey);
        if (extra != null) {
            serviceKeyMetric.setExtraInfo(extra);
        }
        if ((metrics = (stats = this.serviceWrapperNumStats.get(wrapper)).get(serviceKeyMetric)) == null) {
            metrics = stats.computeIfAbsent(serviceKeyMetric, k -> new AtomicLong(0L));
            this.samplesChanged.set(true);
        }
        metrics.set(num);
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (MetricsKeyWrapper wrapper : this.serviceWrapperNumStats.keySet()) {
            Map<ServiceKeyMetric, AtomicLong> stringAtomicLongMap = this.serviceWrapperNumStats.get(wrapper);
            for (ServiceKeyMetric serviceKeyMetric : stringAtomicLongMap.keySet()) {
                list.add(new GaugeMetricSample<Map>(wrapper, serviceKeyMetric.getTags(), category, stringAtomicLongMap, value -> ((AtomicLong)value.get(serviceKeyMetric)).get()));
            }
        }
        return list;
    }

    @Override
    public boolean calSamplesChanged() {
        return this.samplesChanged.compareAndSet(true, false);
    }
}

