/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.dubbo.common.utils.JRE;

public class ConcurrentHashMapUtils {
    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> func) {
        Objects.requireNonNull(func);
        if (JRE.JAVA_8.isCurrentVersion()) {
            Object v = map.get(key);
            if (null == v) {
                v = func.apply(key);
                if (null == v) {
                    return null;
                }
                V res = map.putIfAbsent(key, v);
                if (null != res) {
                    return res;
                }
            }
            return v;
        }
        return map.computeIfAbsent(key, func);
    }
}

